/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.model.BuildParamPrototype;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CreateBuildOptions
extends GenericModel {
    protected String projectId;
    protected String name;
    protected String outputImage;
    protected String outputSecret;
    protected String strategyType;
    protected List<BuildParamPrototype> runBuildParams;
    protected String sourceContextDir;
    protected String sourceRevision;
    protected String sourceSecret;
    protected String sourceType;
    protected String sourceUrl;
    protected String strategySize;
    protected String strategySpecFile;
    protected Long timeout;

    protected CreateBuildOptions() {
    }

    protected CreateBuildOptions(Builder builder) {
        Validator.notEmpty(builder.projectId, "projectId cannot be empty");
        Validator.notNull(builder.name, "name cannot be null");
        Validator.notNull(builder.outputImage, "outputImage cannot be null");
        Validator.notNull(builder.outputSecret, "outputSecret cannot be null");
        Validator.notNull(builder.strategyType, "strategyType cannot be null");
        this.projectId = builder.projectId;
        this.name = builder.name;
        this.outputImage = builder.outputImage;
        this.outputSecret = builder.outputSecret;
        this.strategyType = builder.strategyType;
        this.runBuildParams = builder.runBuildParams;
        this.sourceContextDir = builder.sourceContextDir;
        this.sourceRevision = builder.sourceRevision;
        this.sourceSecret = builder.sourceSecret;
        this.sourceType = builder.sourceType;
        this.sourceUrl = builder.sourceUrl;
        this.strategySize = builder.strategySize;
        this.strategySpecFile = builder.strategySpecFile;
        this.timeout = builder.timeout;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String name() {
        return this.name;
    }

    public String outputImage() {
        return this.outputImage;
    }

    public String outputSecret() {
        return this.outputSecret;
    }

    public String strategyType() {
        return this.strategyType;
    }

    public List<BuildParamPrototype> runBuildParams() {
        return this.runBuildParams;
    }

    public String sourceContextDir() {
        return this.sourceContextDir;
    }

    public String sourceRevision() {
        return this.sourceRevision;
    }

    public String sourceSecret() {
        return this.sourceSecret;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public String sourceUrl() {
        return this.sourceUrl;
    }

    public String strategySize() {
        return this.strategySize;
    }

    public String strategySpecFile() {
        return this.strategySpecFile;
    }

    public Long timeout() {
        return this.timeout;
    }

    public static class Builder {
        private String projectId;
        private String name;
        private String outputImage;
        private String outputSecret;
        private String strategyType;
        private List<BuildParamPrototype> runBuildParams;
        private String sourceContextDir;
        private String sourceRevision;
        private String sourceSecret;
        private String sourceType;
        private String sourceUrl;
        private String strategySize;
        private String strategySpecFile;
        private Long timeout;

        private Builder(CreateBuildOptions createBuildOptions) {
            this.projectId = createBuildOptions.projectId;
            this.name = createBuildOptions.name;
            this.outputImage = createBuildOptions.outputImage;
            this.outputSecret = createBuildOptions.outputSecret;
            this.strategyType = createBuildOptions.strategyType;
            this.runBuildParams = createBuildOptions.runBuildParams;
            this.sourceContextDir = createBuildOptions.sourceContextDir;
            this.sourceRevision = createBuildOptions.sourceRevision;
            this.sourceSecret = createBuildOptions.sourceSecret;
            this.sourceType = createBuildOptions.sourceType;
            this.sourceUrl = createBuildOptions.sourceUrl;
            this.strategySize = createBuildOptions.strategySize;
            this.strategySpecFile = createBuildOptions.strategySpecFile;
            this.timeout = createBuildOptions.timeout;
        }

        public Builder() {
        }

        public Builder(String projectId, String name, String outputImage, String outputSecret, String strategyType) {
            this.projectId = projectId;
            this.name = name;
            this.outputImage = outputImage;
            this.outputSecret = outputSecret;
            this.strategyType = strategyType;
        }

        public CreateBuildOptions build() {
            return new CreateBuildOptions(this);
        }

        public Builder addRunBuildParams(BuildParamPrototype runBuildParams) {
            Validator.notNull(runBuildParams, "runBuildParams cannot be null");
            if (this.runBuildParams == null) {
                this.runBuildParams = new ArrayList<BuildParamPrototype>();
            }
            this.runBuildParams.add(runBuildParams);
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder outputImage(String outputImage) {
            this.outputImage = outputImage;
            return this;
        }

        public Builder outputSecret(String outputSecret) {
            this.outputSecret = outputSecret;
            return this;
        }

        public Builder strategyType(String strategyType) {
            this.strategyType = strategyType;
            return this;
        }

        public Builder runBuildParams(List<BuildParamPrototype> runBuildParams) {
            this.runBuildParams = runBuildParams;
            return this;
        }

        public Builder sourceContextDir(String sourceContextDir) {
            this.sourceContextDir = sourceContextDir;
            return this;
        }

        public Builder sourceRevision(String sourceRevision) {
            this.sourceRevision = sourceRevision;
            return this;
        }

        public Builder sourceSecret(String sourceSecret) {
            this.sourceSecret = sourceSecret;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public Builder strategySize(String strategySize) {
            this.strategySize = strategySize;
            return this;
        }

        public Builder strategySpecFile(String strategySpecFile) {
            this.strategySpecFile = strategySpecFile;
            return this;
        }

        public Builder timeout(long timeout2) {
            this.timeout = timeout2;
            return this;
        }
    }

    public static interface StrategySize {
        public static final String SMALL = "small";
        public static final String MEDIUM = "medium";
        public static final String LARGE = "large";
        public static final String XLARGE = "xlarge";
        public static final String XXLARGE = "xxlarge";
    }

    public static interface SourceType {
        public static final String LOCAL = "local";
        public static final String GIT = "git";
    }

    public static interface StrategyType {
        public static final String DOCKERFILE = "dockerfile";
        public static final String BUILDPACKS = "buildpacks";
    }
}

