/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.model.EnvVarPrototype;
import com.ibm.cloud.code_engine.code_engine.v2.model.VolumeMountPrototype;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CreateJobOptions
extends GenericModel {
    protected String projectId;
    protected String imageReference;
    protected String name;
    protected String imageSecret;
    protected List<String> runArguments;
    protected Long runAsUser;
    protected List<String> runCommands;
    protected Boolean runComputeResourceTokenEnabled;
    protected List<EnvVarPrototype> runEnvVariables;
    protected String runMode;
    protected String runServiceAccount;
    protected List<VolumeMountPrototype> runVolumeMounts;
    protected String scaleArraySpec;
    protected String scaleCpuLimit;
    protected String scaleEphemeralStorageLimit;
    protected Long scaleMaxExecutionTime;
    protected String scaleMemoryLimit;
    protected Long scaleRetryLimit;

    protected CreateJobOptions() {
    }

    protected CreateJobOptions(Builder builder) {
        Validator.notEmpty(builder.projectId, "projectId cannot be empty");
        Validator.notNull(builder.imageReference, "imageReference cannot be null");
        Validator.notNull(builder.name, "name cannot be null");
        this.projectId = builder.projectId;
        this.imageReference = builder.imageReference;
        this.name = builder.name;
        this.imageSecret = builder.imageSecret;
        this.runArguments = builder.runArguments;
        this.runAsUser = builder.runAsUser;
        this.runCommands = builder.runCommands;
        this.runComputeResourceTokenEnabled = builder.runComputeResourceTokenEnabled;
        this.runEnvVariables = builder.runEnvVariables;
        this.runMode = builder.runMode;
        this.runServiceAccount = builder.runServiceAccount;
        this.runVolumeMounts = builder.runVolumeMounts;
        this.scaleArraySpec = builder.scaleArraySpec;
        this.scaleCpuLimit = builder.scaleCpuLimit;
        this.scaleEphemeralStorageLimit = builder.scaleEphemeralStorageLimit;
        this.scaleMaxExecutionTime = builder.scaleMaxExecutionTime;
        this.scaleMemoryLimit = builder.scaleMemoryLimit;
        this.scaleRetryLimit = builder.scaleRetryLimit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String imageReference() {
        return this.imageReference;
    }

    public String name() {
        return this.name;
    }

    public String imageSecret() {
        return this.imageSecret;
    }

    public List<String> runArguments() {
        return this.runArguments;
    }

    public Long runAsUser() {
        return this.runAsUser;
    }

    public List<String> runCommands() {
        return this.runCommands;
    }

    public Boolean runComputeResourceTokenEnabled() {
        return this.runComputeResourceTokenEnabled;
    }

    public List<EnvVarPrototype> runEnvVariables() {
        return this.runEnvVariables;
    }

    public String runMode() {
        return this.runMode;
    }

    public String runServiceAccount() {
        return this.runServiceAccount;
    }

    public List<VolumeMountPrototype> runVolumeMounts() {
        return this.runVolumeMounts;
    }

    public String scaleArraySpec() {
        return this.scaleArraySpec;
    }

    public String scaleCpuLimit() {
        return this.scaleCpuLimit;
    }

    public String scaleEphemeralStorageLimit() {
        return this.scaleEphemeralStorageLimit;
    }

    public Long scaleMaxExecutionTime() {
        return this.scaleMaxExecutionTime;
    }

    public String scaleMemoryLimit() {
        return this.scaleMemoryLimit;
    }

    public Long scaleRetryLimit() {
        return this.scaleRetryLimit;
    }

    public static class Builder {
        private String projectId;
        private String imageReference;
        private String name;
        private String imageSecret;
        private List<String> runArguments;
        private Long runAsUser;
        private List<String> runCommands;
        private Boolean runComputeResourceTokenEnabled;
        private List<EnvVarPrototype> runEnvVariables;
        private String runMode;
        private String runServiceAccount;
        private List<VolumeMountPrototype> runVolumeMounts;
        private String scaleArraySpec;
        private String scaleCpuLimit;
        private String scaleEphemeralStorageLimit;
        private Long scaleMaxExecutionTime;
        private String scaleMemoryLimit;
        private Long scaleRetryLimit;

        private Builder(CreateJobOptions createJobOptions) {
            this.projectId = createJobOptions.projectId;
            this.imageReference = createJobOptions.imageReference;
            this.name = createJobOptions.name;
            this.imageSecret = createJobOptions.imageSecret;
            this.runArguments = createJobOptions.runArguments;
            this.runAsUser = createJobOptions.runAsUser;
            this.runCommands = createJobOptions.runCommands;
            this.runComputeResourceTokenEnabled = createJobOptions.runComputeResourceTokenEnabled;
            this.runEnvVariables = createJobOptions.runEnvVariables;
            this.runMode = createJobOptions.runMode;
            this.runServiceAccount = createJobOptions.runServiceAccount;
            this.runVolumeMounts = createJobOptions.runVolumeMounts;
            this.scaleArraySpec = createJobOptions.scaleArraySpec;
            this.scaleCpuLimit = createJobOptions.scaleCpuLimit;
            this.scaleEphemeralStorageLimit = createJobOptions.scaleEphemeralStorageLimit;
            this.scaleMaxExecutionTime = createJobOptions.scaleMaxExecutionTime;
            this.scaleMemoryLimit = createJobOptions.scaleMemoryLimit;
            this.scaleRetryLimit = createJobOptions.scaleRetryLimit;
        }

        public Builder() {
        }

        public Builder(String projectId, String imageReference, String name) {
            this.projectId = projectId;
            this.imageReference = imageReference;
            this.name = name;
        }

        public CreateJobOptions build() {
            return new CreateJobOptions(this);
        }

        public Builder addRunArguments(String runArguments) {
            Validator.notNull(runArguments, "runArguments cannot be null");
            if (this.runArguments == null) {
                this.runArguments = new ArrayList<String>();
            }
            this.runArguments.add(runArguments);
            return this;
        }

        public Builder addRunCommands(String runCommands) {
            Validator.notNull(runCommands, "runCommands cannot be null");
            if (this.runCommands == null) {
                this.runCommands = new ArrayList<String>();
            }
            this.runCommands.add(runCommands);
            return this;
        }

        public Builder addRunEnvVariables(EnvVarPrototype runEnvVariables) {
            Validator.notNull(runEnvVariables, "runEnvVariables cannot be null");
            if (this.runEnvVariables == null) {
                this.runEnvVariables = new ArrayList<EnvVarPrototype>();
            }
            this.runEnvVariables.add(runEnvVariables);
            return this;
        }

        public Builder addRunVolumeMounts(VolumeMountPrototype runVolumeMounts) {
            Validator.notNull(runVolumeMounts, "runVolumeMounts cannot be null");
            if (this.runVolumeMounts == null) {
                this.runVolumeMounts = new ArrayList<VolumeMountPrototype>();
            }
            this.runVolumeMounts.add(runVolumeMounts);
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder imageReference(String imageReference) {
            this.imageReference = imageReference;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder imageSecret(String imageSecret) {
            this.imageSecret = imageSecret;
            return this;
        }

        public Builder runArguments(List<String> runArguments) {
            this.runArguments = runArguments;
            return this;
        }

        public Builder runAsUser(long runAsUser) {
            this.runAsUser = runAsUser;
            return this;
        }

        public Builder runCommands(List<String> runCommands) {
            this.runCommands = runCommands;
            return this;
        }

        public Builder runComputeResourceTokenEnabled(Boolean runComputeResourceTokenEnabled) {
            this.runComputeResourceTokenEnabled = runComputeResourceTokenEnabled;
            return this;
        }

        public Builder runEnvVariables(List<EnvVarPrototype> runEnvVariables) {
            this.runEnvVariables = runEnvVariables;
            return this;
        }

        public Builder runMode(String runMode) {
            this.runMode = runMode;
            return this;
        }

        public Builder runServiceAccount(String runServiceAccount) {
            this.runServiceAccount = runServiceAccount;
            return this;
        }

        public Builder runVolumeMounts(List<VolumeMountPrototype> runVolumeMounts) {
            this.runVolumeMounts = runVolumeMounts;
            return this;
        }

        public Builder scaleArraySpec(String scaleArraySpec) {
            this.scaleArraySpec = scaleArraySpec;
            return this;
        }

        public Builder scaleCpuLimit(String scaleCpuLimit) {
            this.scaleCpuLimit = scaleCpuLimit;
            return this;
        }

        public Builder scaleEphemeralStorageLimit(String scaleEphemeralStorageLimit) {
            this.scaleEphemeralStorageLimit = scaleEphemeralStorageLimit;
            return this;
        }

        public Builder scaleMaxExecutionTime(long scaleMaxExecutionTime) {
            this.scaleMaxExecutionTime = scaleMaxExecutionTime;
            return this;
        }

        public Builder scaleMemoryLimit(String scaleMemoryLimit) {
            this.scaleMemoryLimit = scaleMemoryLimit;
            return this;
        }

        public Builder scaleRetryLimit(long scaleRetryLimit) {
            this.scaleRetryLimit = scaleRetryLimit;
            return this;
        }
    }

    public static interface RunServiceAccount {
        public static final String X_DEFAULT = "default";
        public static final String MANAGER = "manager";
        public static final String READER = "reader";
        public static final String WRITER = "writer";
        public static final String NONE = "none";
    }

    public static interface RunMode {
        public static final String TASK = "task";
        public static final String DAEMON = "daemon";
    }
}

