/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import java.util.Base64;
import org.apache.commons.lang3.StringUtils;

public class AuthenticatorBase {
    public static final String ERRORMSG_PROP_MISSING = "The %s property is required but was not specified.";
    public static final String ERRORMSG_PROP_INVALID = "The %s property is invalid. Please remove any surrounding {, }, or \" characters.";
    public static final String ERRORMSG_REQ_FAILED = "Error while fetching access token from token service: ";
    public static final String ERRORMSG_EXCLUSIVE_PROP_ERROR = "Exactly one of %s or %s must be specified.";
    public static final String ERRORMSG_ATLEAST_ONE_PROP_ERROR = "At least one of %s or %s must be specified.";
    public static final String ERRORMSG_ATMOST_ONE_PROP_ERROR = "At most one of %s or %s may be specified.";
    public static final String ERRORMSG_PROP_INVALID_INTEGER_VALUE = "The %s property must be a valid integer but was %s.";
    public static final String ERRORMSG_ACCOUNTID_PROP_ERROR = "iamAccountId must be specified if and only if iamProfileName is specified";
    public static final String ERRORMSG_PROP_INVALID_BOOL = "The %s property must be a valid boolean but was '%s'. Valid values are 'true' and 'false'.";

    public static String constructBasicAuthHeader(String username, String password) {
        if (StringUtils.isNotEmpty(username) && StringUtils.isNotEmpty(password)) {
            return "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
        }
        return null;
    }

    public static String constructBearerTokenAuthHeader(String bearerToken) {
        if (StringUtils.isNotEmpty(bearerToken)) {
            return "Bearer " + bearerToken;
        }
        return null;
    }
}

