/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.IamRequestBasedAuthenticator;
import com.ibm.cloud.sdk.core.security.IamToken;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import java.io.IOException;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.FormBody;
import org.apache.commons.lang3.StringUtils;

public class ContainerAuthenticator
extends IamRequestBasedAuthenticator
implements Authenticator {
    private static final Logger LOG = Logger.getLogger(ContainerAuthenticator.class.getName());
    private static final String OPERATION_PATH = "/identity/token";
    private static final String DEFAULT_CR_TOKEN_FILENAME1 = "/var/run/secrets/tokens/vault-token";
    private static final String DEFAULT_CR_TOKEN_FILENAME2 = "/var/run/secrets/tokens/sa-token";
    private static final String DEFAULT_CR_TOKEN_FILENAME3 = "/var/run/secrets/codeengine.cloud.ibm.com/compute-resource-token/token";
    private static final String ERRORMSG_CR_TOKEN_ERROR = "Error reading CR token file: %s";
    private String crTokenFilename;
    private String iamProfileName;
    private String iamProfileId;

    protected ContainerAuthenticator() {
        this.setUserAgent(RequestUtils.buildUserAgent("container-authenticator"));
    }

    protected ContainerAuthenticator(Builder builder) {
        this();
        this.crTokenFilename = builder.crTokenFilename;
        this.iamProfileName = builder.iamProfileName;
        this.iamProfileId = builder.iamProfileId;
        this.setURL(builder.url);
        this.setScope(builder.scope);
        this.setClientIdAndSecret(builder.clientId, builder.clientSecret);
        this.setDisableSSLVerification(builder.disableSSLVerification);
        this.setHeaders(builder.headers);
        this.setProxy(builder.proxy);
        this.setProxyAuthenticator(builder.proxyAuthenticator);
        this.validate();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static ContainerAuthenticator fromConfiguration(Map<String, String> config) {
        return new Builder().crTokenFilename(config.get("CR_TOKEN_FILENAME")).iamProfileName(config.get("IAM_PROFILE_NAME")).iamProfileId(config.get("IAM_PROFILE_ID")).url(config.get("AUTH_URL")).scope(config.get("SCOPE")).clientId(config.get("CLIENT_ID")).clientSecret(config.get("CLIENT_SECRET")).disableSSLVerification(Boolean.valueOf(config.get("AUTH_DISABLE_SSL"))).build();
    }

    @Override
    public void validate() {
        super.validate();
        if (StringUtils.isEmpty(this.getURL())) {
            this.setURL("https://iam.cloud.ibm.com");
        } else {
            this.setURL(StringUtils.removeEnd(this.getURL(), OPERATION_PATH));
        }
        if (StringUtils.isEmpty(this.getIamProfileName()) && StringUtils.isEmpty(this.getIamProfileId())) {
            throw new IllegalArgumentException(String.format("At least one of %s or %s must be specified.", "iamProfileName", "iamProfileId"));
        }
    }

    @Override
    public String authenticationType() {
        return "container";
    }

    public String getCrTokenFilename() {
        return this.crTokenFilename;
    }

    public String getIamProfileName() {
        return this.iamProfileName;
    }

    public String getIamProfileId() {
        return this.iamProfileId;
    }

    @Override
    public IamToken requestToken() {
        IamToken token;
        try {
            String crToken = this.retrieveCRToken();
            RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getURL(), OPERATION_PATH));
            builder.header("Accept", "application/json");
            builder.header("Content-Type", "application/x-www-form-urlencoded");
            builder.header("User-Agent", this.getUserAgent());
            this.addAuthorizationHeader(builder);
            FormBody.Builder formBodyBuilder = new FormBody.Builder().add("grant_type", "urn:ibm:params:oauth:grant-type:cr-token").add("cr_token", crToken);
            if (!StringUtils.isEmpty(this.getIamProfileId())) {
                formBodyBuilder.add("profile_id", this.getIamProfileId());
            }
            if (!StringUtils.isEmpty(this.getIamProfileName())) {
                formBodyBuilder.add("profile_name", this.getIamProfileName());
            }
            if (!StringUtils.isEmpty(this.getScope())) {
                formBodyBuilder.add("scope", this.getScope());
            }
            FormBody formBody = formBodyBuilder.build();
            builder.body(formBody);
            LOG.log(Level.FINE, "Invoking IAM get_token operation: POST {0}", builder.toUrl());
            token = this.invokeRequest(builder, IamToken.class);
            LOG.log(Level.FINE, "Returned from IAM get_token operation");
        }
        catch (Throwable t) {
            token = new IamToken(t);
            LOG.log(Level.FINE, "Exception from IAM get_token operation: ", t);
        }
        return token;
    }

    protected String retrieveCRToken() {
        try {
            String crToken = null;
            if (StringUtils.isNotEmpty(this.getCrTokenFilename())) {
                crToken = this.readFile(this.getCrTokenFilename());
            } else {
                try {
                    crToken = this.readFile(DEFAULT_CR_TOKEN_FILENAME1);
                }
                catch (Throwable t) {
                    try {
                        crToken = this.readFile(DEFAULT_CR_TOKEN_FILENAME2);
                    }
                    catch (Throwable t1) {
                        crToken = this.readFile(DEFAULT_CR_TOKEN_FILENAME3);
                    }
                }
            }
            return crToken;
        }
        catch (Throwable t) {
            String msg = t.getMessage() != null ? t.getMessage() : t.getClass().getName();
            throw new RuntimeException(String.format(ERRORMSG_CR_TOKEN_ERROR, msg), t);
        }
    }

    protected String readFile(String filename) throws IOException {
        try {
            String crToken = null;
            LOG.log(Level.FINE, "Attempting to read CR token from file: {0}", filename);
            byte[] bytes = Files.readAllBytes(Paths.get(filename, new String[0]));
            crToken = new String(bytes, StandardCharsets.UTF_8);
            LOG.log(Level.FINE, "Successfully read CR token from file: {0}", filename);
            return crToken;
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, "Error reading CR token: ", t);
            throw t;
        }
    }

    public static class Builder {
        private String crTokenFilename;
        private String iamProfileName;
        private String iamProfileId;
        private String url;
        private String scope;
        private String clientId;
        private String clientSecret;
        private boolean disableSSLVerification;
        private Map<String, String> headers;
        private Proxy proxy;
        private okhttp3.Authenticator proxyAuthenticator;

        public Builder() {
        }

        private Builder(ContainerAuthenticator obj) {
            this.crTokenFilename = obj.crTokenFilename;
            this.iamProfileName = obj.iamProfileName;
            this.iamProfileId = obj.iamProfileId;
            this.url = obj.getURL();
            this.scope = obj.getScope();
            this.clientId = obj.getClientId();
            this.clientSecret = obj.getClientSecret();
            this.disableSSLVerification = obj.getDisableSSLVerification();
            this.headers = obj.getHeaders();
            this.proxy = obj.getProxy();
            this.proxyAuthenticator = obj.getProxyAuthenticator();
        }

        public ContainerAuthenticator build() {
            return new ContainerAuthenticator(this);
        }

        public Builder crTokenFilename(String crTokenFilename) {
            this.crTokenFilename = crTokenFilename;
            return this;
        }

        public Builder iamProfileName(String iamProfileName) {
            this.iamProfileName = iamProfileName;
            return this;
        }

        public Builder iamProfileId(String iamProfileId) {
            this.iamProfileId = iamProfileId;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder disableSSLVerification(boolean disableSSLVerification) {
            this.disableSSLVerification = disableSSLVerification;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(okhttp3.Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }
    }
}

