/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.MCSPToken;
import com.ibm.cloud.sdk.core.security.MCSPV2TokenResponse;
import com.ibm.cloud.sdk.core.security.TokenRequestBasedAuthenticatorImmutable;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class MCSPV2Authenticator
extends TokenRequestBasedAuthenticatorImmutable<MCSPToken, MCSPV2TokenResponse>
implements Authenticator {
    private static final Logger LOG = Logger.getLogger(MCSPV2Authenticator.class.getName());
    private static final String OPERATION_PATH = "/api/2.0/{scopeCollectionType}/{scopeId}/apikeys/token";
    private String apikey;
    private String url;
    private String scopeCollectionType;
    private String scopeId;
    private boolean includeBuiltinActions;
    private boolean includeCustomActions;
    private boolean includeRoles;
    private boolean prefixRoles;
    private Map<String, String> callerExtClaim;

    protected MCSPV2Authenticator() {
        this.setUserAgent(RequestUtils.buildUserAgent("mcspv2-authenticator"));
        this.includeRoles = true;
    }

    protected MCSPV2Authenticator(Builder builder) {
        this();
        this.apikey = builder.apikey;
        this.url = builder.url;
        this.scopeCollectionType = builder.scopeCollectionType;
        this.scopeId = builder.scopeId;
        this.includeBuiltinActions = builder.includeBuiltinActions;
        this.includeCustomActions = builder.includeCustomActions;
        this.includeRoles = builder.includeRoles;
        this.prefixRoles = builder.prefixRoles;
        this.callerExtClaim = builder.callerExtClaim;
        this._setDisableSSLVerification(builder.disableSSLVerification);
        this._setHeaders(builder.headers);
        this._setProxy(builder.proxy);
        this._setProxyAuthenticator(builder.proxyAuthenticator);
        this._setClient(builder.client);
        this.validate();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static MCSPV2Authenticator fromConfiguration(Map<String, String> config) {
        Boolean bool;
        Builder builder = new Builder().apikey(config.get("APIKEY")).url(config.get("AUTH_URL")).scopeCollectionType(config.get("SCOPE_COLLECTION_TYPE")).scopeId(config.get("SCOPE_ID"));
        String strValue = config.get("INCLUDE_BUILTIN_ACTIONS");
        if (StringUtils.isNotEmpty(strValue)) {
            bool = BooleanUtils.toBooleanObject(strValue);
            if (bool == null) {
                throw new IllegalArgumentException(String.format("The %s property must be a valid boolean but was '%s'. Valid values are 'true' and 'false'.", "INCLUDE_BUILTIN_ACTIONS", strValue));
            }
            builder.includeBuiltinActions(bool);
        }
        if (StringUtils.isNotEmpty(strValue = config.get("INCLUDE_CUSTOM_ACTIONS"))) {
            bool = BooleanUtils.toBooleanObject(strValue);
            if (bool == null) {
                throw new IllegalArgumentException(String.format("The %s property must be a valid boolean but was '%s'. Valid values are 'true' and 'false'.", "INCLUDE_CUSTOM_ACTIONS", strValue));
            }
            builder.includeCustomActions(bool);
        }
        if (StringUtils.isNotEmpty(strValue = config.get("INCLUDE_ROLES"))) {
            bool = BooleanUtils.toBooleanObject(strValue);
            if (bool == null) {
                throw new IllegalArgumentException(String.format("The %s property must be a valid boolean but was '%s'. Valid values are 'true' and 'false'.", "INCLUDE_ROLES", strValue));
            }
            builder.includeRoles(bool);
        }
        if (StringUtils.isNotEmpty(strValue = config.get("PREFIX_ROLES"))) {
            bool = BooleanUtils.toBooleanObject(strValue);
            if (bool == null) {
                throw new IllegalArgumentException(String.format("The %s property must be a valid boolean but was '%s'. Valid values are 'true' and 'false'.", "PREFIX_ROLES", strValue));
            }
            builder.prefixRoles(bool);
        }
        if (StringUtils.isNotEmpty(strValue = config.get("AUTH_DISABLE_SSL"))) {
            bool = BooleanUtils.toBooleanObject(strValue);
            if (bool == null) {
                throw new IllegalArgumentException(String.format("The %s property must be a valid boolean but was '%s'. Valid values are 'true' and 'false'.", "AUTH_DISABLE_SSL", strValue));
            }
            builder.disableSSLVerification(bool);
        }
        if (StringUtils.isNotEmpty(strValue = config.get("CALLER_EXT_CLAIM"))) {
            Gson gson = GsonSingleton.getGsonWithoutPrettyPrinting();
            Type mapType = new TypeToken<Map<String, String>>(){}.getType();
            Map callerExtClaim = (Map)gson.fromJson(strValue, mapType);
            builder.callerExtClaim(callerExtClaim);
        }
        return builder.build();
    }

    @Override
    public void validate() {
        if (StringUtils.isEmpty(this.getURL())) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "url"));
        }
        if (StringUtils.isEmpty(this.apikey)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "apikey"));
        }
        if (StringUtils.isEmpty(this.scopeCollectionType)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "scopeCollectionType"));
        }
        if (StringUtils.isEmpty(this.scopeId)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "scopeId"));
        }
    }

    @Override
    public String authenticationType() {
        return "mcspv2";
    }

    public String getApiKey() {
        return this.apikey;
    }

    public String getURL() {
        return this.url;
    }

    public String getScopeCollectionType() {
        return this.scopeCollectionType;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public boolean includeBuiltinActions() {
        return this.includeBuiltinActions;
    }

    public boolean includeCustomActions() {
        return this.includeCustomActions;
    }

    public boolean includeRoles() {
        return this.includeRoles;
    }

    public boolean prefixRoles() {
        return this.prefixRoles;
    }

    public Map<String, String> getCallerExtClaim() {
        return this.callerExtClaim;
    }

    @Override
    public MCSPToken requestToken() {
        MCSPToken token;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("scopeCollectionType", this.getScopeCollectionType());
        pathParams.put("scopeId", this.getScopeId());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getURL(), OPERATION_PATH, pathParams));
        builder.header("Accept", "application/json");
        builder.header("Content-Type", "application/json");
        builder.header("User-Agent", this.getUserAgent());
        builder.query("includeBuiltinActions", this.includeBuiltinActions());
        builder.query("includeCustomActions", this.includeCustomActions());
        builder.query("includeRoles", this.includeRoles());
        builder.query("prefixRolesWithDefinitionScope", this.prefixRoles());
        MCSPV2RequestBody requestBody = new MCSPV2RequestBody(this.getApiKey(), this.getCallerExtClaim());
        builder.bodyContent("application/json", (Object)requestBody, null, (InputStream)null);
        try {
            LOG.log(Level.FINE, "Invoking MCSPv2 token service operation: POST {0}", builder.toUrl());
            MCSPV2TokenResponse response = this.invokeRequest(builder, MCSPV2TokenResponse.class);
            LOG.log(Level.FINE, "Returned from MCSPv2 token service operation");
            token = new MCSPToken(response);
        }
        catch (Throwable t) {
            token = new MCSPToken(t);
            LOG.log(Level.FINE, "Exception from MCSPv2 token service operation: ", t);
        }
        return token;
    }

    private static class MCSPV2RequestBody {
        private String apikey;
        private Map<String, String> callerExtClaim;

        MCSPV2RequestBody(String apikey, Map<String, String> callerExtClaim) {
            this.apikey = apikey;
            this.callerExtClaim = callerExtClaim;
        }
    }

    public static class Builder {
        private String apikey;
        private String url;
        private String scopeCollectionType;
        private String scopeId;
        private boolean includeBuiltinActions;
        private boolean includeCustomActions;
        private boolean includeRoles;
        private boolean prefixRoles;
        private Map<String, String> callerExtClaim;
        private boolean disableSSLVerification;
        private Map<String, String> headers;
        private Proxy proxy;
        private okhttp3.Authenticator proxyAuthenticator;
        private OkHttpClient client;

        public Builder() {
            this.includeRoles = true;
        }

        private Builder(MCSPV2Authenticator obj) {
            this.apikey = obj.apikey;
            this.url = obj.getURL();
            this.scopeCollectionType = obj.getScopeCollectionType();
            this.scopeId = obj.getScopeId();
            this.includeBuiltinActions = obj.includeBuiltinActions();
            this.includeCustomActions = obj.includeCustomActions();
            this.includeRoles = obj.includeRoles();
            this.prefixRoles = obj.prefixRoles();
            this.callerExtClaim = obj.getCallerExtClaim();
            this.disableSSLVerification = obj.getDisableSSLVerification();
            this.headers = obj.getHeaders();
            this.proxy = obj.getProxy();
            this.proxyAuthenticator = obj.getProxyAuthenticator();
            this.client = obj.getClient();
        }

        public MCSPV2Authenticator build() {
            return new MCSPV2Authenticator(this);
        }

        public Builder apikey(String apikey) {
            this.apikey = apikey;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder scopeCollectionType(String scopeCollectionType) {
            this.scopeCollectionType = scopeCollectionType;
            return this;
        }

        public Builder scopeId(String scopeId) {
            this.scopeId = scopeId;
            return this;
        }

        public Builder includeBuiltinActions(boolean includeBuiltinActions) {
            this.includeBuiltinActions = includeBuiltinActions;
            return this;
        }

        public Builder includeCustomActions(boolean includeCustomActions) {
            this.includeCustomActions = includeCustomActions;
            return this;
        }

        public Builder includeRoles(boolean includeRoles) {
            this.includeRoles = includeRoles;
            return this;
        }

        public Builder prefixRoles(boolean prefixRoles) {
            this.prefixRoles = prefixRoles;
            return this;
        }

        public Builder callerExtClaim(Map<String, String> callerExtClaim) {
            this.callerExtClaim = callerExtClaim;
            return this;
        }

        public Builder disableSSLVerification(boolean disableSSLVerification) {
            this.disableSSLVerification = disableSSLVerification;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(okhttp3.Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        public Builder client(OkHttpClient client) {
            this.client = client;
            return this;
        }
    }
}

