/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.ibm_cloud_code_engine.v1;

import com.ibm.cloud.code_engine.common.SdkCommon;
import com.ibm.cloud.code_engine.ibm_cloud_code_engine.v1.model.GetKubeconfigOptions;
import com.ibm.cloud.code_engine.ibm_cloud_code_engine.v1.model.ListKubeconfigOptions;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;

public class IbmCloudCodeEngine
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "ibm_cloud_code_engine";
    public static final String DEFAULT_SERVICE_URL = "https://ibm-cloud-code-engine.cloud.ibm.com/api/v1";

    public static IbmCloudCodeEngine newInstance() {
        return IbmCloudCodeEngine.newInstance(DEFAULT_SERVICE_NAME);
    }

    public static IbmCloudCodeEngine newInstance(String serviceName) {
        Authenticator authenticator = ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName);
        IbmCloudCodeEngine service = new IbmCloudCodeEngine(serviceName, authenticator);
        service.configureService(serviceName);
        return service;
    }

    public IbmCloudCodeEngine(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
    }

    public ServiceCall<String> listKubeconfig(ListKubeconfigOptions listKubeconfigOptions) {
        Validator.notNull((Object)((Object)listKubeconfigOptions), (String)"listKubeconfigOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", listKubeconfigOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/namespaces/{id}/config", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listKubeconfig");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Refresh-Token", listKubeconfigOptions.refreshToken()});
        if (listKubeconfigOptions.accept() != null) {
            builder.header(new Object[]{"Accept", listKubeconfigOptions.accept()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getString();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<String> getKubeconfig(GetKubeconfigOptions getKubeconfigOptions) {
        Validator.notNull((Object)((Object)getKubeconfigOptions), (String)"getKubeconfigOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("id", getKubeconfigOptions.id());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/project/{id}/config", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getKubeconfig");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"X-Delegated-Refresh-Token", getKubeconfigOptions.xDelegatedRefreshToken()});
        if (getKubeconfigOptions.accept() != null) {
            builder.header(new Object[]{"Accept", getKubeconfigOptions.accept()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getString();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

