/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.CodeEngine;
import com.ibm.cloud.code_engine.code_engine.v2.model.JobRun;
import com.ibm.cloud.code_engine.code_engine.v2.model.JobRunList;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListJobRunsOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class JobRunsPager {
    protected boolean hasNext;
    protected ListJobRunsOptions options;
    protected CodeEngine client;
    protected PageContext pageContext;

    protected JobRunsPager() {
    }

    public JobRunsPager(CodeEngine client, ListJobRunsOptions options) {
        if (options.start() != null) {
            throw new IllegalArgumentException("The options 'start' field should not be set");
        }
        this.hasNext = true;
        this.client = client;
        this.options = options.newBuilder().build();
        this.pageContext = new PageContext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public List<JobRun> getNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more results available");
        }
        ListJobRunsOptions.Builder builder = this.options.newBuilder();
        if (this.pageContext.getNext() != null) {
            builder.start(this.pageContext.getNext());
        }
        this.options = builder.build();
        JobRunList result = (JobRunList)((Object)this.client.listJobRuns(this.options).execute().getResult());
        String next = null;
        if (result.getNext() != null) {
            next = result.getNext().getStart();
        }
        this.pageContext.setNext(next);
        if (next == null) {
            this.hasNext = false;
        }
        return result.getJobRuns();
    }

    public List<JobRun> getAll() {
        ArrayList<JobRun> results = new ArrayList<JobRun>();
        while (this.hasNext()) {
            List<JobRun> nextPage = this.getNext();
            results.addAll(nextPage);
        }
        return results;
    }

    private static class PageContext {
        private String next;

        private PageContext() {
        }

        public String getNext() {
            return this.next;
        }

        public void setNext(String next) {
            this.next = next;
        }
    }
}

