/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.model.SecretData;
import com.ibm.cloud.code_engine.code_engine.v2.model.ServiceAccessSecretPrototypeProps;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class CreateSecretOptions
extends GenericModel {
    protected String projectId;
    protected String format;
    protected String name;
    protected SecretData data;
    protected ServiceAccessSecretPrototypeProps serviceAccess;

    protected CreateSecretOptions() {
    }

    protected CreateSecretOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notNull((Object)builder.format, (String)"format cannot be null");
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        this.projectId = builder.projectId;
        this.format = builder.format;
        this.name = builder.name;
        this.data = builder.data;
        this.serviceAccess = builder.serviceAccess;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String format() {
        return this.format;
    }

    public String name() {
        return this.name;
    }

    public SecretData data() {
        return this.data;
    }

    public ServiceAccessSecretPrototypeProps serviceAccess() {
        return this.serviceAccess;
    }

    public static class Builder {
        private String projectId;
        private String format;
        private String name;
        private SecretData data;
        private ServiceAccessSecretPrototypeProps serviceAccess;

        private Builder(CreateSecretOptions createSecretOptions) {
            this.projectId = createSecretOptions.projectId;
            this.format = createSecretOptions.format;
            this.name = createSecretOptions.name;
            this.data = createSecretOptions.data;
            this.serviceAccess = createSecretOptions.serviceAccess;
        }

        public Builder() {
        }

        public Builder(String projectId, String format, String name) {
            this.projectId = projectId;
            this.format = format;
            this.name = name;
        }

        public CreateSecretOptions build() {
            return new CreateSecretOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder data(SecretData data) {
            this.data = data;
            return this;
        }

        public Builder serviceAccess(ServiceAccessSecretPrototypeProps serviceAccess) {
            this.serviceAccess = serviceAccess;
            return this;
        }
    }

    public static interface Format {
        public static final String GENERIC = "generic";
        public static final String SSH_AUTH = "ssh_auth";
        public static final String BASIC_AUTH = "basic_auth";
        public static final String TLS = "tls";
        public static final String SERVICE_ACCESS = "service_access";
        public static final String REGISTRY = "registry";
        public static final String OTHER = "other";
    }
}

