/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.code_engine.code_engine.v2.model;

import com.ibm.cloud.code_engine.code_engine.v2.CodeEngine;
import com.ibm.cloud.code_engine.code_engine.v2.model.DomainMapping;
import com.ibm.cloud.code_engine.code_engine.v2.model.DomainMappingList;
import com.ibm.cloud.code_engine.code_engine.v2.model.ListDomainMappingsOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class DomainMappingsPager {
    protected boolean hasNext;
    protected ListDomainMappingsOptions options;
    protected CodeEngine client;
    protected PageContext pageContext;

    protected DomainMappingsPager() {
    }

    public DomainMappingsPager(CodeEngine client, ListDomainMappingsOptions options) {
        if (options.start() != null) {
            throw new IllegalArgumentException("The options 'start' field should not be set");
        }
        this.hasNext = true;
        this.client = client;
        this.options = options.newBuilder().build();
        this.pageContext = new PageContext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public List<DomainMapping> getNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more results available");
        }
        ListDomainMappingsOptions.Builder builder = this.options.newBuilder();
        if (this.pageContext.getNext() != null) {
            builder.start(this.pageContext.getNext());
        }
        this.options = builder.build();
        DomainMappingList result = (DomainMappingList)((Object)this.client.listDomainMappings(this.options).execute().getResult());
        String next = null;
        if (result.getNext() != null) {
            next = result.getNext().getStart();
        }
        this.pageContext.setNext(next);
        if (next == null) {
            this.hasNext = false;
        }
        return result.getDomainMappings();
    }

    public List<DomainMapping> getAll() {
        ArrayList<DomainMapping> results = new ArrayList<DomainMapping>();
        while (this.hasNext()) {
            List<DomainMapping> nextPage = this.getNext();
            results.addAll(nextPage);
        }
        return results;
    }

    private static class PageContext {
        private String next;

        private PageContext() {
        }

        public String getNext() {
            return this.next;
        }

        public void setNext(String next) {
            this.next = next;
        }
    }
}

