/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.optim.oaas.client.OaasException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class OaasLogFormatter
extends Formatter {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public OaasLogFormatter() {
        this.dateFormat.setTimeZone(TimeZone.GMT_ZONE);
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.dateFormat.format(new Date(record.getMillis())));
        sb.append(" ");
        sb.append(record.getLevel().getName().charAt(0));
        sb.append(" ");
        sb.append(this.formatMessage(record));
        Throwable ex = record.getThrown();
        if (ex != null) {
            sb.append("\r\n");
            sb.append("Exception: ");
            StringWriter stringWriter = new StringWriter();
            ex.printStackTrace(new PrintWriter(stringWriter));
            sb.append(stringWriter.toString());
            Throwable rootCause = OaasException.getRootCause(ex);
            if (rootCause != null && rootCause != ex) {
                sb.append("\r\n");
                sb.append("Root cause: ");
                stringWriter = new StringWriter();
                rootCause.printStackTrace(new PrintWriter(stringWriter));
                sb.append(stringWriter.toString());
            }
        }
        sb.append("\r\n");
        return sb.toString();
    }
}

