/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.optim.oaas.client.job.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.icu.text.DateFormat;
import com.ibm.optim.oaas.client.OperationException;
import com.ibm.optim.oaas.client.impl.Validate;
import com.ibm.optim.oaas.client.job.JobException;
import com.ibm.optim.oaas.client.job.JobExecutor;
import com.ibm.optim.oaas.client.job.JobInput;
import com.ibm.optim.oaas.client.job.JobOutput;
import com.ibm.optim.oaas.client.job.JobRequest;
import com.ibm.optim.oaas.client.job.JobRequestBuilder;
import com.ibm.optim.oaas.client.job.JobResponse;
import com.ibm.optim.oaas.client.job.impl.JobClientImpl;
import com.ibm.optim.oaas.client.job.impl.JobFileInputImpl;
import com.ibm.optim.oaas.client.job.impl.JobFileOutputImpl;
import com.ibm.optim.oaas.client.job.impl.JobJsonInputImpl;
import com.ibm.optim.oaas.client.job.impl.JobJsonOutputImpl;
import com.ibm.optim.oaas.client.job.impl.JobLogFileOutputImpl;
import com.ibm.optim.oaas.client.job.impl.JobLogOutputImpl;
import com.ibm.optim.oaas.client.job.impl.JobLogStreamOutputImpl;
import com.ibm.optim.oaas.client.job.impl.JobRequestImpl;
import com.ibm.optim.oaas.client.job.impl.JobStreamInputImpl;
import com.ibm.optim.oaas.client.job.impl.JobStreamOutputImpl;
import com.ibm.optim.oaas.client.job.impl.JobURLInputImpl;
import com.ibm.optim.oaas.client.job.model.JobCreationData;
import com.ibm.optim.oaas.client.job.model.impl.JobAttachmentImpl;
import com.ibm.optim.oaas.client.job.model.impl.JobCreationDataImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class JobRequestBuilderImpl
implements JobRequestBuilder {
    private JobClientImpl client;
    private JobCreationData data;
    private List<JobInput> inputList = new ArrayList<JobInput>();
    private List<JobOutput> outputList = new ArrayList<JobOutput>();
    private List<JobLogOutputImpl> logoutput = new ArrayList<JobLogOutputImpl>();
    private OutputStream livelog;
    private boolean delete;
    private long timeout;
    private DateFormat livelogDateFormat;
    private String email;
    private String copy;
    private boolean shallow;
    private boolean batchSubmitMode = false;
    private String recreate;

    public JobRequestBuilderImpl(JobClientImpl client) {
        Validate.notNull(client, "client");
        this.data = client.newJobCreationData();
        this.client = client;
    }

    @Override
    public JobRequestBuilderImpl application(String applicationId) {
        Validate.notNull(applicationId, "applicationId");
        this.data.setApplicationId(applicationId);
        return this;
    }

    @Override
    public JobRequestBuilderImpl input(File file) {
        Validate.notNull(file, "file");
        this.inputList.add(new JobFileInputImpl(file));
        return this;
    }

    @Override
    public JobRequestBuilderImpl input(String name, File file) {
        Validate.notNull(name, "name");
        Validate.notNull(file, "file");
        this.inputList.add(new JobFileInputImpl(name, file));
        return this;
    }

    @Override
    public JobRequestBuilderImpl input(String name, URL url) {
        Validate.notNull(name, "name");
        Validate.notNull(url, "URL");
        this.inputList.add(new JobURLInputImpl(name, url));
        return this;
    }

    @Override
    public JobRequestBuilderImpl input(String name, InputStream stream) {
        Validate.notNull(name, "name");
        Validate.notNull(stream, "stream");
        this.inputList.add(new JobStreamInputImpl(name, stream));
        return this;
    }

    @Override
    public JobRequestBuilderImpl input(String name, ObjectMapper mapper, Object obj) {
        Validate.notNull(name, "name");
        Validate.notNull(mapper, "mapper");
        Validate.notNull(this.inputList, "input");
        this.inputList.add(new JobJsonInputImpl(name, mapper, obj));
        return this;
    }

    @Override
    public JobRequestBuilder output(File file) {
        Validate.notNull(file, "file");
        this.outputList.add(new JobFileOutputImpl(file));
        return this;
    }

    @Override
    public JobRequestBuilder output(OutputStream stream) {
        Validate.notNull(stream, "stream");
        this.outputList.add(new JobStreamOutputImpl(stream));
        return this;
    }

    @Override
    public <T> JobRequestBuilder output(ObjectMapper mapper, TypeReference<T> type) {
        Validate.notNull(mapper, "mapper");
        Validate.notNull(type, "type");
        this.outputList.add(new JobJsonOutputImpl<T>(mapper, type));
        return this;
    }

    @Override
    public <T> JobRequestBuilder output(ObjectMapper mapper, Class<T> type) {
        Validate.notNull(mapper, "mapper");
        Validate.notNull(type, "type");
        this.outputList.add(new JobJsonOutputImpl<T>(mapper, type));
        return this;
    }

    @Override
    public JobRequestBuilder log(File file) {
        Validate.notNull(file, "file");
        this.logoutput.add(new JobLogFileOutputImpl(file));
        return this;
    }

    @Override
    public JobRequestBuilder log(OutputStream stream) {
        Validate.notNull(stream, "stream");
        this.logoutput.add(new JobLogStreamOutputImpl(stream));
        return this;
    }

    @Override
    public JobRequestBuilder deleteOnCompletion(boolean delete) {
        this.delete = delete;
        return this;
    }

    @Override
    public JobRequestBuilderImpl version(String version) {
        Validate.notNull(version, "version");
        this.data.setApplicationVersion(version);
        return this;
    }

    @Override
    public JobRequestBuilderImpl parameter(String name, Object value) {
        Validate.notNull(name, "name");
        Validate.notNull(value, "value");
        this.data.getParameters().put(name, value.toString());
        return this;
    }

    @Override
    public JobRequestBuilder timeout(long timeout, TimeUnit unit) {
        Validate.notNull(unit, "unit");
        this.timeout = timeout > 0L ? unit.toMillis(timeout) : timeout;
        return this;
    }

    @Override
    public JobRequest build() {
        JobCreationDataImpl jobdata = this.client.newJobCreationData();
        jobdata.setClientName(this.data.getClientName());
        jobdata.setClientEmail(this.email);
        jobdata.setApplicationId(this.data.getApplicationId());
        jobdata.setApplicationVersion(this.data.getApplicationVersion());
        jobdata.getParameters().putAll(this.data.getParameters());
        for (JobInput jobinput : this.inputList) {
            JobAttachmentImpl att = jobdata.addJobAttachment(jobinput.getName());
            long length = jobinput.getLength();
            if (length < 0L) continue;
            att.setLength(length);
        }
        return new JobRequestImpl(this.client, jobdata, this.inputList, this.outputList, this.logoutput, this.delete, this.timeout, this.livelog, this.livelogDateFormat, this.copy, this.shallow, this.recreate, this.batchSubmitMode);
    }

    @Override
    public Future<JobResponse> execute(JobExecutor executor) throws OperationException, IOException, InterruptedException, JobException {
        return this.build().execute(executor);
    }

    @Override
    public Future<JobResponse> create(JobExecutor executor) throws OperationException, IOException, InterruptedException, JobException {
        return this.build().create(executor);
    }

    @Override
    public JobRequestBuilder livelog(OutputStream stream) {
        Validate.notNull(stream, "stream");
        this.livelog = stream;
        return this;
    }

    @Override
    public JobRequestBuilder livelog(OutputStream stream, DateFormat format) {
        Validate.notNull(stream, "stream");
        Validate.notNull(format, "format");
        this.livelog = stream;
        this.livelogDateFormat = format;
        return this;
    }

    @Override
    public JobRequestBuilder clientName(String name) {
        Validate.notNull(name, "name");
        this.data.setClientName(name);
        return this;
    }

    @Override
    public JobRequestBuilder input(JobInput input) {
        Validate.notNull(input, "input");
        Validate.notNull(input.getName(), "input.name");
        this.inputList.add(input);
        return this;
    }

    @Override
    public JobRequestBuilder output(JobOutput output) {
        Validate.notNull(output, "output");
        this.outputList.add(output);
        return this;
    }

    @Override
    public JobRequestBuilder clientEmail(String email) {
        Validate.notNull(email, "email");
        this.email = email;
        return this;
    }

    @Override
    public JobRequestBuilder copy(String jobId) {
        Validate.notNull(jobId, "jobId");
        this.copy = jobId;
        return this;
    }

    @Override
    public JobRequestBuilder copy(String jobId, boolean shallow) {
        Validate.notNull(jobId, "jobId");
        this.copy = jobId;
        this.shallow = shallow;
        return this;
    }

    @Override
    public JobRequestBuilder recreate(String jobId) {
        Validate.notNull(jobId, "jobId");
        this.recreate = jobId;
        return this;
    }

    @Override
    public JobRequestBuilder useBatchSubmitMode() {
        this.batchSubmitMode = true;
        return this;
    }

    @Override
    public JobRequestBuilder output(String attid, File file) {
        Validate.notNull(file, "file");
        this.outputList.add(new JobFileOutputImpl(attid, file));
        return this;
    }

    @Override
    public <T> JobRequestBuilder output(String attid, ObjectMapper mapper, Class<T> type) {
        Validate.notNull(mapper, "mapper");
        Validate.notNull(type, "type");
        this.outputList.add(new JobJsonOutputImpl<T>(attid, mapper, type));
        return this;
    }

    @Override
    public <T> JobRequestBuilder output(String attid, ObjectMapper mapper, TypeReference<T> type) {
        Validate.notNull(mapper, "mapper");
        Validate.notNull(type, "type");
        this.outputList.add(new JobJsonOutputImpl<T>(attid, mapper, type));
        return this;
    }

    @Override
    public JobRequestBuilder output(String attid, OutputStream stream) {
        Validate.notNull(stream, "stream");
        this.outputList.add(new JobStreamOutputImpl(attid, stream));
        return this;
    }
}

