/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MatchFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$match");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$match");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$match");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$match");
    public static String ERR_ARG4BADTYPE = String.format("Argument 4 of function %s does not match function signature", "$match");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        JsonNode argLimit;
        ArrayNode result = null;
        NullNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(ctx, this.getSignature());
        int argCount = this.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            ++argCount;
        }
        if (argCount != 2 && argCount != 3) throw new EvaluateRuntimeException(argCount <= 1 ? ERR_ARG1BADTYPE : ERR_ARG4BADTYPE);
        if (!useContext) {
            argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argString == null) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        if (!argString.isTextual()) {
            throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        }
        JsonNode argPattern = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
        int limit = -1;
        if (argString == null || !argString.isTextual() || argString.asText().isEmpty()) {
            throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        }
        if (argPattern == null || !argPattern.isTextual() || argPattern.asText().isEmpty()) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        String str = argString.textValue();
        String pattern = argPattern.textValue();
        if (argCount == 3 && (argLimit = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 1 : 2)) != null) {
            if (!argLimit.isNumber() || argLimit.asInt() < 0) throw new EvaluateRuntimeException(ERR_ARG3BADTYPE);
            limit = argLimit.asInt();
        }
        Pattern regexPattern = Pattern.compile(pattern);
        Matcher matcher = regexPattern.matcher(str);
        result = JsonNodeFactory.instance.arrayNode();
        if (limit == -1) {
            while (matcher.find()) {
                ObjectNode obj = JsonNodeFactory.instance.objectNode();
                obj.put("match", str.substring(matcher.start(), matcher.end()));
                obj.put("start", new Long(matcher.start()));
                ArrayNode groups = JsonNodeFactory.instance.arrayNode();
                obj.set("groups", (JsonNode)groups);
                groups.add(matcher.group());
                result.add((JsonNode)obj);
            }
            return result;
        } else {
            if (limit <= 0) return null;
            for (int count = 0; matcher.find() && count < limit; ++count) {
                ObjectNode obj = JsonNodeFactory.instance.objectNode();
                obj.put("match", str.substring(matcher.start(), matcher.end()));
                obj.put("start", new Long(matcher.start()));
                ArrayNode groups = JsonNodeFactory.instance.arrayNode();
                obj.set("groups", (JsonNode)groups);
                groups.add(matcher.group());
                result.add((JsonNode)obj);
            }
        }
        return result;
    }

    @Override
    public String getSignature() {
        return "<s-f<s:o>n?:a<o>>";
    }
}

