/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;

public class FormatBaseFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$formatBase");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$formatBase");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$formatBase");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$formatBase");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        TextNode result = null;
        JsonNode argNumber = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(ctx, this.getSignature());
        int argCount = this.getArgumentCount(ctx);
        if (useContext) {
            argNumber = FunctionUtils.getContextVariable(expressionVisitor);
            ++argCount;
        }
        if (argCount != 1 && argCount != 2) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG3BADTYPE);
        if (!useContext) {
            argNumber = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argNumber == null) return result;
        if (!argNumber.isNumber()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        int number = argNumber.asInt();
        int radix = 10;
        if (argCount != 2) return new TextNode(Integer.toString(number, radix));
        JsonNode argRadix = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
        if (argRadix == null) return new TextNode(Integer.toString(number, radix));
        if (!argRadix.isNumber()) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        radix = argRadix.asInt();
        if (radix < 2) throw new EvaluateRuntimeException("The radix of the $formatBase function must be between 2 and 36");
        if (radix <= 36) return new TextNode(Integer.toString(number, radix));
        throw new EvaluateRuntimeException("The radix of the $formatBase function must be between 2 and 36");
    }

    @Override
    public String getSignature() {
        return "<n-n?:s>";
    }
}

