/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Objects;

public class SubstringAfterFunction
extends FunctionBase
implements Function {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$substringAfter");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$substringAfter");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$substringAfter");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$substringAfter");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        TextNode result = null;
        NullNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = SubstringAfterFunction.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            if (argString != null && !argString.isNull()) {
                ++argCount;
            } else {
                if (argString == null) {
                    return null;
                }
                useContext = false;
            }
        }
        if (argCount == 1 || argCount == 2) {
            if (!useContext) {
                argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            }
            if (argCount == 1) {
                if (argString == null || argString.isTextual()) {
                    throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
                }
                throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            }
            JsonNode argChars = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
            if (argChars == null) {
                if (argString == null) {
                    return null;
                }
                if (argString.isTextual()) {
                    return new TextNode(argString.textValue());
                }
                throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            }
            if (argString != null) {
                String chars;
                if (!argString.isTextual()) {
                    throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
                }
                if (!argChars.isTextual()) {
                    throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
                }
                String str = argString.textValue();
                int index = str.indexOf(chars = argChars.textValue());
                result = index != -1 ? (index + chars.length() < str.length() ? new TextNode(SubstringAfterFunction.substr(str, index + chars.length())) : new TextNode("")) : new TextNode(str);
            }
        } else {
            throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : ERR_ARG3BADTYPE);
        }
        return result;
    }

    private static String substr(String str, Integer start) {
        Integer length = null;
        int origLen = str.length();
        String strData = Objects.requireNonNull(str).intern();
        int strLen = strData.codePointCount(0, strData.length());
        if ((start = Integer.valueOf(strData.offsetByCodePoints(0, start >= 0 ? start : (strLen + start < 0 ? 0 : strLen + start)))) < 0) {
            start = 0;
        }
        if (length == null) {
            length = strData.length();
        }
        length = strData.offsetByCodePoints(0, length);
        if (start >= 0 && start >= origLen) {
            return "";
        }
        int end = start + length;
        if (end > origLen) {
            end = origLen;
        }
        return strData.substring(start, end);
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<s-s:s>";
    }
}

