/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions;

import com.api.jsonata4java.expressions.JS4JUtils;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class JS4JDate
extends Date
implements Cloneable {
    public static String CREATE_DATE_FORMAT = "yyyy/MM/dd-HH:mm:ss.SSS(Z)";
    public static String CREATE_DATE_FORMAT_0 = "yyyy/MM/dd-HH:mm:ss.SSS";
    public static String CREATE_DATE_FORMAT_1 = "yyyy/MM/dd-HH:mm:ss";
    public static String CREATE_DATE_FORMAT_10 = "yyyy/MM/dd HH:mm:ss.SSSSSS";
    public static String CREATE_DATE_FORMAT_11 = "E, dd MMM yyyy HH:mm:ss";
    public static String CREATE_DATE_FORMAT_12 = "MMMM dd yyyy HH:mm:ss";
    public static String CREATE_DATE_FORMAT_2 = "yyyy/MM/dd-HH:mm";
    public static String CREATE_DATE_FORMAT_3 = "yyyy/MM/dd-HH";
    public static String CREATE_DATE_FORMAT_4 = "yyyy/MM/dd";
    public static String CREATE_DATE_FORMAT_5 = "yyyy/MM/dd-HH:mm:ss(Z)";
    public static String CREATE_DATE_FORMAT_6 = "yyyy/MM/dd-HH:mm(Z)";
    public static String CREATE_DATE_FORMAT_7 = "yyyy/MM/dd-HH(Z)";
    public static String CREATE_DATE_FORMAT_8 = "yyyy/MM/dd(Z)";
    public static String CREATE_DATE_FORMAT_9 = "yyyy/MM/ddTHH";
    public static String m_strClassName = JS4JDate.class.getSimpleName();
    private static final long serialVersionUID = -1235455818943814022L;
    public static final long UNDEFINED_JS4JDate_Milliseconds = 1L;
    public static final JS4JDate UNDEFINED_JS4JDate = new JS4JDate(1L);
    public static final String UNDEFINED_Aiden_DB2_Date_String = new JS4JDate(UNDEFINED_JS4JDate).toStringDBTimestamp();

    public static String convertDateTime(String strDateTime) {
        if (strDateTime == null || strDateTime.length() == 0) {
            return UNDEFINED_JS4JDate.toString();
        }
        strDateTime = strDateTime.replace('-', '/');
        if ((strDateTime = strDateTime.replace('T', '-')).length() == 11) {
            strDateTime = strDateTime.substring(0, 10);
        }
        strDateTime = !strDateTime.toUpperCase().endsWith("Z") ? strDateTime + "(+0000)" : strDateTime.substring(0, strDateTime.length() - 1) + "(+0000)";
        return strDateTime;
    }

    public static String getHexTime() {
        return Long.toHexString(new JS4JDate().getTime());
    }

    public static boolean isUndefined(JS4JDate date) {
        if (date == null) {
            return true;
        }
        return date.getTime() <= 1L;
    }

    public static boolean isUndefined(Date date) {
        if (date == null) {
            return true;
        }
        return date.getTime() <= 1L;
    }

    public static synchronized Date makeDate(String strDate) throws Exception {
        String[] dateParts;
        int iZOffset;
        int iHOffset;
        int iTOffset;
        int day;
        String newDate;
        if (strDate == null || strDate.length() == 0) {
            return new Date();
        }
        String[] parts = strDate.split(" ");
        if (parts.length == 4) {
            newDate = parts[2].trim() + "/";
            switch (parts[0].trim().toLowerCase()) {
                case "january": {
                    newDate = newDate + "01/";
                    break;
                }
                case "february": {
                    newDate = newDate + "02/";
                    break;
                }
                case "march": {
                    newDate = newDate + "03/";
                    break;
                }
                case "april": {
                    newDate = newDate + "04/";
                    break;
                }
                case "may": {
                    newDate = newDate + "05/";
                    break;
                }
                case "june": {
                    newDate = newDate + "06/";
                    break;
                }
                case "july": {
                    newDate = newDate + "07/";
                    break;
                }
                case "august": {
                    newDate = newDate + "08/";
                    break;
                }
                case "september": {
                    newDate = newDate + "09/";
                    break;
                }
                case "october": {
                    newDate = newDate + "10/";
                    break;
                }
                case "november": {
                    newDate = newDate + "11/";
                    break;
                }
                case "december": {
                    newDate = newDate + "12/";
                    break;
                }
                default: {
                    throw new Exception("Unrecognized month \"" + parts[2] + "\" in input " + strDate);
                }
            }
            try {
                day = new Integer(parts[1].trim());
                if (day < 10) {
                    newDate = newDate + "0";
                }
                newDate = newDate + day;
                newDate = newDate + "T";
            }
            catch (NumberFormatException nfe) {
                throw new Exception("Unrecognized day of month \"" + parts[1] + "\" in input " + strDate);
            }
            if (parts[3].trim().length() != 8) {
                throw new Exception("Unrecognized time \"" + parts[3] + "\" in input " + strDate);
            }
            strDate = newDate = newDate + parts[3].trim();
        } else if (parts.length == 5) {
            newDate = parts[3] + "/";
            switch (parts[2].trim().toLowerCase()) {
                case "jan": {
                    newDate = newDate + "01/";
                    break;
                }
                case "feb": {
                    newDate = newDate + "02/";
                    break;
                }
                case "mar": {
                    newDate = newDate + "03/";
                    break;
                }
                case "apr": {
                    newDate = newDate + "04/";
                    break;
                }
                case "may": {
                    newDate = newDate + "05/";
                    break;
                }
                case "jun": {
                    newDate = newDate + "06/";
                    break;
                }
                case "jul": {
                    newDate = newDate + "07/";
                    break;
                }
                case "aug": {
                    newDate = newDate + "08/";
                    break;
                }
                case "sep": {
                    newDate = newDate + "09/";
                    break;
                }
                case "oct": {
                    newDate = newDate + "10/";
                    break;
                }
                case "nov": {
                    newDate = newDate + "11/";
                    break;
                }
                case "dec": {
                    newDate = newDate + "12/";
                    break;
                }
                default: {
                    throw new Exception("Unrecognized month \"" + parts[3] + "\" in input " + strDate);
                }
            }
            try {
                day = new Integer(parts[1].trim());
                if (day < 10) {
                    newDate = newDate + "0";
                }
                newDate = newDate + day;
                newDate = newDate + "T";
            }
            catch (NumberFormatException nfe) {
                throw new Exception("Unrecognized day of month \"" + parts[1] + "\" in input " + strDate);
            }
            if (parts[4].trim().length() != 8) {
                throw new Exception("Unrecognized time \"" + parts[4] + "\" in input " + strDate);
            }
            strDate = newDate = newDate + parts[4].trim();
        }
        int iSpaceOffset = strDate.indexOf(" ");
        if (iSpaceOffset == 10) {
            strDate = strDate.replace(' ', 'T');
        }
        if ((iTOffset = strDate.indexOf("T")) == 10) {
            strDate = JS4JDate.convertDateTime(strDate);
        }
        if ((iHOffset = strDate.indexOf("-")) > 0 && iHOffset <= 9) {
            strDate = strDate.replace('-', '/');
        }
        if (strDate.length() == 10) {
            strDate = strDate + "-00:00:00.000(+0000)";
        }
        if ((iZOffset = strDate.toUpperCase().indexOf("Z")) > 0) {
            strDate = strDate.substring(0, iZOffset) + "(+0000)";
        }
        int iTZOffset = strDate.indexOf("(");
        int iMSOffset = strDate.indexOf(".");
        if (iMSOffset > 0) {
            String strMS;
            if (iTZOffset > 0) {
                if (iTZOffset - iMSOffset > 4) {
                    strMS = strDate.substring(iMSOffset + 1, iTZOffset);
                    int iMSLen = strMS.length();
                    if (iMSLen > 3) {
                        strMS = strMS.substring(0, 3) + "." + strMS.substring(3);
                    }
                    int imsecs = Math.round(new Float(strMS).floatValue());
                    strMS = JS4JUtils.padRight(imsecs, 3, '0');
                    String strTZ = strDate.substring(iTZOffset);
                    strDate = strDate.substring(0, iMSOffset + 1) + strMS + strTZ;
                    iTZOffset = strDate.indexOf("(");
                } else {
                    String strTZ = strDate.substring(iTZOffset);
                    String strMS2 = strDate.substring(iMSOffset + 1, iTZOffset);
                    strMS2 = JS4JUtils.padRight(strMS2, 3, '0');
                    strDate = strDate.substring(0, iMSOffset + 1) + strMS2 + strTZ;
                }
            } else if (strDate.length() - iMSOffset > 3) {
                strMS = strDate.substring(iMSOffset + 1);
                strMS = strMS.substring(0, 3) + "." + strMS.substring(3);
                int imsecs = Math.round(new Float(strMS).floatValue());
                strMS = JS4JUtils.padRight(imsecs, 3, '0');
                strDate = strDate.substring(0, iMSOffset) + strMS;
            } else {
                strMS = strDate.substring(iMSOffset + 1);
                strMS = JS4JUtils.padRight(strMS, 3, '0');
                strDate = strDate.substring(0, iMSOffset + 1) + strMS;
            }
        }
        int iMinOffset = strDate.indexOf(":");
        int iSecOffset = strDate.lastIndexOf(":");
        int iTimeOffset = strDate.indexOf("-");
        if (iTimeOffset > iTZOffset && iTZOffset != -1) {
            iTimeOffset = -1;
        }
        if (strDate.length() >= 10 && (dateParts = strDate.substring(0, 10).split("/")).length >= 3) {
            for (int i = 0; i < 3; ++i) {
                try {
                    int test = Integer.parseInt(dateParts[i]);
                    switch (i) {
                        case 0: {
                            if (test >= 1900 && test <= 2500) break;
                            throw new Exception("Invalid year. Must be between 1900 and 2500 inclusive. Received: \"" + dateParts[i] + "\"");
                        }
                        case 1: {
                            if (test >= 1 && test <= 12) break;
                            throw new Exception("Invalid month. Must be between 1 and 12 inclusive. Received: \"" + dateParts[i] + "\"");
                        }
                        case 2: {
                            if (test >= 1 && test <= 31) break;
                            throw new Exception("Invalid day. Must be between 1 and 31 (depending on the month and leap year) inclusive. Received: \"" + dateParts[i] + "\"");
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Date contains \"" + dateParts[i] + "\"", e);
                }
            }
        }
        if (strDate.length() > 11) {
            String[] timeParts;
            String time = strDate.substring(11);
            if (time.length() > 8) {
                time = time.substring(0, 8);
            }
            if ((timeParts = time.split(":")).length >= 3) {
                for (int i = 0; i < 3; ++i) {
                    try {
                        int test = Integer.parseInt(timeParts[i]);
                        switch (i) {
                            case 0: {
                                if (test >= 0 && test <= 23) break;
                                throw new Exception("Invalid hour. Must be between 1 and 23 inclusive. Received: \"" + timeParts[i] + "\"");
                            }
                            case 1: {
                                if (test >= 0 && test <= 59) break;
                                throw new Exception("Invalid minutes. Must be between 0 and 59 inclusive. Received: \"" + timeParts[i] + "\"");
                            }
                            case 2: {
                                if (test >= 0 && test <= 59) break;
                                throw new Exception("Invalid day. Must be between 0 and 59 inclusive. Received: \"" + timeParts[i] + "\"");
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        throw new Exception("Date contains \"" + timeParts[i] + "\"", e);
                    }
                }
            }
        }
        try {
            SimpleDateFormat sdFormat;
            if (iTimeOffset == -1) {
                sdFormat = null;
                if (iTZOffset == -1) {
                    sdFormat = new SimpleDateFormat(CREATE_DATE_FORMAT_4, new DateFormatSymbols());
                    sdFormat.setTimeZone(TimeZone.getDefault());
                } else {
                    sdFormat = new SimpleDateFormat(CREATE_DATE_FORMAT_8, new DateFormatSymbols());
                }
                return sdFormat.parse(strDate);
            }
            if (iSecOffset == -1) {
                sdFormat = null;
                if (iTZOffset == -1) {
                    sdFormat = new SimpleDateFormat(CREATE_DATE_FORMAT_3, new DateFormatSymbols());
                    sdFormat.setTimeZone(TimeZone.getDefault());
                } else {
                    sdFormat = new SimpleDateFormat(CREATE_DATE_FORMAT_7, new DateFormatSymbols());
                }
                return sdFormat.parse(strDate);
            }
            if (iSecOffset == iMinOffset) {
                sdFormat = null;
                if (iTZOffset == -1) {
                    sdFormat = new SimpleDateFormat(CREATE_DATE_FORMAT_2, new DateFormatSymbols());
                    sdFormat.setTimeZone(TimeZone.getDefault());
                } else {
                    sdFormat = new SimpleDateFormat(CREATE_DATE_FORMAT_6, new DateFormatSymbols());
                }
                return sdFormat.parse(strDate);
            }
            if (iMSOffset == -1) {
                sdFormat = null;
                if (iTZOffset == -1) {
                    sdFormat = new SimpleDateFormat(CREATE_DATE_FORMAT_1, new DateFormatSymbols());
                    sdFormat.setTimeZone(TimeZone.getDefault());
                } else {
                    sdFormat = new SimpleDateFormat(CREATE_DATE_FORMAT_5, new DateFormatSymbols());
                }
                return sdFormat.parse(strDate);
            }
            if (iTZOffset == -1) {
                sdFormat = new SimpleDateFormat(CREATE_DATE_FORMAT_0, new DateFormatSymbols());
                sdFormat.setTimeZone(TimeZone.getDefault());
                return sdFormat.parse(strDate);
            }
            return new SimpleDateFormat(CREATE_DATE_FORMAT, new DateFormatSymbols()).parse(strDate);
        }
        catch (ParseException e) {
            throw new Exception("Date \"" + strDate + "\" does not parse according to the format \"" + CREATE_DATE_FORMAT + "\"");
        }
    }

    public static synchronized String makeFormattedDate(Date date, String strFormat, String strTimeZone) {
        SimpleDateFormat dateformat;
        int iTZMillisecs = JS4JUtils.convertTimeZoneToMilliseconds(strTimeZone);
        try {
            dateformat = new SimpleDateFormat(strFormat, new DateFormatSymbols());
        }
        catch (Exception e) {
            dateformat = new SimpleDateFormat(CREATE_DATE_FORMAT, new DateFormatSymbols());
        }
        dateformat.setTimeZone(new SimpleTimeZone(iTZMillisecs, strTimeZone));
        return dateformat.format(date);
    }

    public static synchronized String makeFormattedLocalDate(Date date) {
        return new SimpleDateFormat(CREATE_DATE_FORMAT, new DateFormatSymbols()).format(date);
    }

    public static long MAX_TIME() {
        return 253402214399999L;
    }

    public static JS4JDate MAX_VALUE() {
        return new JS4JDate(JS4JDate.MAX_TIME());
    }

    public static JS4JDate MIN_VALUE() {
        return new JS4JDate(0L);
    }

    public static String parseTimeZoneFromListEntry(String strTimeZoneListEntry) {
        String strTimeZone = "+0000";
        if (strTimeZoneListEntry == null || strTimeZoneListEntry.length() == 0) {
            return strTimeZone;
        }
        int iLength = strTimeZoneListEntry.length();
        if (iLength >= 5) {
            strTimeZone = strTimeZoneListEntry.substring(0, 5);
            try {
                int iTime = new Integer(strTimeZone);
                if (iTime < -1300 || iTime > 1300) {
                    strTimeZone = "+0000";
                }
            }
            catch (NumberFormatException nfe) {
                strTimeZone = "+0000";
            }
        }
        return strTimeZone;
    }

    public static JS4JDate undefinedForNull(JS4JDate date) {
        if (date == null) {
            return UNDEFINED_JS4JDate;
        }
        return date;
    }

    public JS4JDate() {
    }

    public JS4JDate(Date date) {
        if (date == null) {
            date = UNDEFINED_JS4JDate;
        }
        this.setTime(date.getTime());
    }

    public JS4JDate(double dDate) {
        super((long)dDate);
    }

    public JS4JDate(int iYear, int iMonth, int iDay, int iHours, int iMinutes, int iSeconds, int iMilliseconds, String strTimeZone) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (iYear < 100) {
            iYear += 2000;
        }
        sb.append(iYear);
        sb.append("/");
        if (iMonth < 1 || iMonth > 12) {
            throw new Exception("Month is not between 1 and 12, inclusive.");
        }
        if (iMonth < 10) {
            sb.append("0");
        }
        sb.append(iMonth);
        sb.append("/");
        if (iDay < 1 || iDay > 31) {
            throw new Exception("Day is not between 1 and 31, inclusive.");
        }
        if (iDay < 10) {
            sb.append("0");
        }
        sb.append(iDay);
        sb.append("-");
        if (iHours < 0 || iHours > 23) {
            throw new Exception("Hours is not between 0 and 23, inclusive.");
        }
        if (iHours < 10) {
            sb.append("0");
        }
        sb.append(iHours);
        sb.append(":");
        if (iMinutes < 0 || iMinutes > 59) {
            throw new Exception("Minutes is not between 0 and 59, inclusive.");
        }
        if (iMinutes < 10) {
            sb.append("0");
        }
        sb.append(iMinutes);
        sb.append(":");
        if (iSeconds < 0 || iSeconds > 59) {
            throw new Exception("Seconds is not between 0 and 59, inclusive.");
        }
        if (iSeconds < 10) {
            sb.append("0");
        }
        sb.append(iSeconds);
        sb.append(".");
        if (iMilliseconds < 0 || iMilliseconds > 999) {
            throw new Exception("Milliseconds is not between 0 and 999, inclusive.");
        }
        if (iMilliseconds < 10) {
            sb.append("00");
        } else if (iMilliseconds < 100) {
            sb.append("0");
        }
        sb.append(iMilliseconds);
        sb.append("(");
        if (strTimeZone == null || strTimeZone.length() == 0) {
            strTimeZone = "+0000";
        }
        sb.append(strTimeZone);
        sb.append(")");
        this.setTime(JS4JDate.makeDate(sb.toString()).getTime());
    }

    public JS4JDate(long lDate) {
        super(lDate);
    }

    public JS4JDate(String strDate) throws Exception {
        this.setTime(JS4JDate.makeDate(strDate).getTime());
    }

    @Override
    public JS4JDate clone() {
        return new JS4JDate(this);
    }

    @Override
    public int compareTo(JS4JDate aaiDate) {
        return super.compareTo(aaiDate);
    }

    @Override
    public int compareTo(Date date) {
        return super.compareTo(date);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public long getDay(String strTimeZone) {
        GregorianCalendar calDate = new GregorianCalendar(TimeZone.getTimeZone("+0000"));
        calDate.setTimeInMillis(this.getTime());
        ((Calendar)calDate).setTimeZone(TimeZone.getTimeZone(strTimeZone));
        return calDate.get(5);
    }

    public long getHours(String strTimeZone) {
        GregorianCalendar calDate = new GregorianCalendar(TimeZone.getTimeZone("GMT+0000"));
        calDate.setTimeInMillis(this.getTime());
        ((Calendar)calDate).setTimeZone(TimeZone.getTimeZone(strTimeZone));
        return calDate.get(11);
    }

    public long getMilliseconds(String strTimeZone) {
        GregorianCalendar calDate = new GregorianCalendar(TimeZone.getTimeZone("GMT+0000"));
        calDate.setTimeInMillis(this.getTime());
        ((Calendar)calDate).setTimeZone(TimeZone.getTimeZone(strTimeZone));
        return calDate.get(14);
    }

    public long getMinutes(String strTimeZone) {
        GregorianCalendar calDate = new GregorianCalendar(TimeZone.getTimeZone("GMT+0000"));
        calDate.setTimeInMillis(this.getTime());
        ((Calendar)calDate).setTimeZone(TimeZone.getTimeZone(strTimeZone));
        return calDate.get(12);
    }

    public long getMonth(String strTimeZone) {
        GregorianCalendar calDate = new GregorianCalendar(TimeZone.getTimeZone("GMT+0000"));
        calDate.setTimeInMillis(this.getTime());
        ((Calendar)calDate).setTimeZone(TimeZone.getTimeZone(strTimeZone));
        return calDate.get(2) + 1;
    }

    public long getSeconds(String strTimeZone) {
        GregorianCalendar calDate = new GregorianCalendar(TimeZone.getTimeZone("GMT+0000"));
        calDate.setTimeInMillis(this.getTime());
        ((Calendar)calDate).setTimeZone(TimeZone.getTimeZone(strTimeZone));
        return calDate.get(13);
    }

    public long getYear(String strTimeZone) {
        GregorianCalendar calDate = new GregorianCalendar(TimeZone.getTimeZone("GMT+0000"));
        calDate.setTimeInMillis(this.getTime());
        ((Calendar)calDate).setTimeZone(TimeZone.getTimeZone(strTimeZone));
        return calDate.get(1);
    }

    public boolean isUndefined() {
        return JS4JDate.isUndefined(this);
    }

    public void setDay(int iDay, String strTimeZone) {
        GregorianCalendar calDate = new GregorianCalendar(TimeZone.getTimeZone("GMT" + strTimeZone));
        calDate.setTimeInMillis(this.getTime());
        calDate.set(5, iDay);
        this.setTime(calDate.getTime().getTime());
    }

    public void setHours(int iHours, String strTimeZone) {
        GregorianCalendar calDate = new GregorianCalendar(TimeZone.getTimeZone("GMT" + strTimeZone));
        calDate.setTimeInMillis(this.getTime());
        calDate.set(11, iHours);
        this.setTime(calDate.getTime().getTime());
    }

    public void setMilliseconds(int iMilliseconds, String strTimeZone) {
        GregorianCalendar calDate = new GregorianCalendar(TimeZone.getTimeZone("GMT" + strTimeZone));
        calDate.setTimeInMillis(this.getTime());
        calDate.set(14, iMilliseconds);
        this.setTime(calDate.getTime().getTime());
    }

    public void setMinutes(int iMinutes, String strTimeZone) {
        GregorianCalendar calDate = new GregorianCalendar(TimeZone.getTimeZone("GMT" + strTimeZone));
        calDate.setTimeInMillis(this.getTime());
        calDate.set(12, iMinutes);
        this.setTime(calDate.getTime().getTime());
    }

    public void setMonth(int iMonth, String strTimeZone) {
        GregorianCalendar calDate = new GregorianCalendar(TimeZone.getTimeZone("GMT" + strTimeZone));
        calDate.setTimeInMillis(this.getTime());
        calDate.set(2, iMonth - 1);
        this.setTime(calDate.getTime().getTime());
    }

    public void setSeconds(int iSeconds, String strTimeZone) {
        GregorianCalendar calDate = new GregorianCalendar(TimeZone.getTimeZone("GMT" + strTimeZone));
        calDate.setTimeInMillis(this.getTime());
        calDate.set(13, iSeconds);
        this.setTime(calDate.getTime().getTime());
    }

    public void setYear(int iYear, String strTimeZone) {
        GregorianCalendar calDate = new GregorianCalendar(TimeZone.getTimeZone("GMT" + strTimeZone));
        calDate.setTimeInMillis(this.getTime());
        calDate.set(1, iYear);
        this.setTime(calDate.getTime().getTime());
    }

    public Date toDate() {
        return this;
    }

    @Override
    public String toString() {
        return this.toStringDateTime();
    }

    public String toString(String strTimeZone) {
        return JS4JDate.makeFormattedDate(this, CREATE_DATE_FORMAT, strTimeZone);
    }

    public String toString(String strFormat, String strTimeZone) {
        if (strFormat == null) {
            strFormat = CREATE_DATE_FORMAT;
        }
        if (strTimeZone == null) {
            strTimeZone = "+0000";
        }
        return JS4JDate.makeFormattedDate(this, strFormat, strTimeZone);
    }

    public String toStringCookie() {
        String strRC = JS4JDate.makeFormattedDate(this, CREATE_DATE_FORMAT_11, "+0000");
        strRC = strRC.replace('-', ' ');
        strRC = strRC.replace('/', '-');
        return strRC;
    }

    public String toStringDateTime() {
        String strRC = JS4JDate.makeFormattedDate(this, CREATE_DATE_FORMAT_0, "+0000");
        strRC = strRC.replace('-', 'T');
        strRC = strRC.replace('/', '-');
        return strRC + "Z";
    }

    public String toStringDBTimestamp() {
        String strRC = JS4JDate.makeFormattedDate(this, CREATE_DATE_FORMAT_10, "+0000");
        strRC = strRC.replace('-', ' ');
        strRC = strRC.replace('/', '-');
        return strRC;
    }
}

