/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;

public class DistinctFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = -1403211347419923420L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$each");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$each");
    public static String ERR_ARG1_MUST_BE_ARRAY_OF_OBJECTS = String.format("Argument 1 of function \"%s\" must be an object or an array of objects.", "$each");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        JsonNode result = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        JsonNode inputNode = null;
        int argCount = DistinctFunction.getArgumentCount(ctx);
        if (useContext) {
            inputNode = FunctionUtils.getContextVariable(expressionVisitor);
            if (inputNode != null && !inputNode.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount <= 1) {
            if (!useContext) {
                inputNode = expressionVisitor.visit(ctx.exprValues().exprList().expr(0));
            }
            if (inputNode == null) {
                return null;
            }
            if (!inputNode.isArray() || ((ArrayNode)inputNode).size() < 1) {
                result = inputNode;
            } else {
                ArrayNode newResult = inputNode instanceof ExpressionsVisitor.SelectorArrayNode ? new ExpressionsVisitor.SelectorArrayNode(JsonNodeFactory.instance) : JsonNodeFactory.instance.arrayNode();
                ArrayNode array = (ArrayNode)inputNode;
                if (inputNode instanceof ExpressionsVisitor.SelectorArrayNode) {
                    array = (ExpressionsVisitor.SelectorArrayNode)inputNode;
                }
                boolean foundMatch = false;
                for (JsonNode node1 : array) {
                    for (JsonNode node2 : newResult) {
                        if (node1 == null || !node1.equals(node2)) continue;
                        foundMatch = true;
                        break;
                    }
                    if (!foundMatch) {
                        newResult.add(node1);
                    }
                    foundMatch = false;
                }
                result = newResult;
            }
        }
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<x:x>";
    }
}

