/*
 * Decompiled with CFR 0.152.
 */
package com.icoderman.woocommerce;

import com.icoderman.woocommerce.DefaultHttpClient;
import com.icoderman.woocommerce.HttpClient;
import com.icoderman.woocommerce.HttpMethod;
import com.icoderman.woocommerce.WooCommerce;
import com.icoderman.woocommerce.oauth.OAuthConfig;
import com.icoderman.woocommerce.oauth.OAuthSignature;
import java.util.List;
import java.util.Map;

public class WooCommerceAPI
implements WooCommerce {
    private static final String API_URL_FORMAT = "%s/wp-json/wc/v1/%s";
    private static final String API_URL_ONE_ENTITY_FORMAT = "%s/wp-json/wc/v1/%s/%d";
    private static final String URL_SECURED_FORMAT = "%s?%s";
    private HttpClient client;
    private OAuthConfig config;

    public WooCommerceAPI(OAuthConfig config) {
        this.config = config;
        this.client = new DefaultHttpClient();
    }

    @Override
    public Map create(String endpointBase, Map<String, Object> object) {
        String url = String.format(API_URL_FORMAT, this.config.getUrl(), endpointBase);
        return this.client.post(url, OAuthSignature.getAsMap(this.config, url, HttpMethod.POST), object);
    }

    @Override
    public Map get(String endpointBase, int id) {
        String url = String.format(API_URL_ONE_ENTITY_FORMAT, this.config.getUrl(), endpointBase, id);
        String signature = OAuthSignature.getAsQueryString(this.config, url, HttpMethod.GET);
        String securedUrl = String.format(URL_SECURED_FORMAT, url, signature);
        return this.client.get(securedUrl);
    }

    @Override
    public List getAll(String endpointBase) {
        String url = String.format(API_URL_FORMAT, this.config.getUrl(), endpointBase);
        String signature = OAuthSignature.getAsQueryString(this.config, url, HttpMethod.GET);
        String securedUrl = String.format(URL_SECURED_FORMAT, url, signature);
        return this.client.getAll(securedUrl);
    }

    @Override
    public Map update(String endpointBase, int id, Map<String, Object> object) {
        String url = String.format(API_URL_ONE_ENTITY_FORMAT, this.config.getUrl(), endpointBase, id);
        return this.client.put(url, OAuthSignature.getAsMap(this.config, url, HttpMethod.PUT), object);
    }

    @Override
    public Map delete(String endpointBase, int id) {
        String url = String.format(API_URL_ONE_ENTITY_FORMAT, this.config.getUrl(), endpointBase, id);
        Map<String, String> params = OAuthSignature.getAsMap(this.config, url, HttpMethod.DELETE);
        return this.client.delete(url, params);
    }
}

