/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging;

import com.imsweb.decisionengine.ColumnDefinition;
import com.imsweb.decisionengine.DecisionEngine;
import com.imsweb.decisionengine.Error;
import com.imsweb.decisionengine.Result;
import com.imsweb.staging.SchemaLookup;
import com.imsweb.staging.StagingData;
import com.imsweb.staging.StagingDataProvider;
import com.imsweb.staging.entities.StagingColumnDefinition;
import com.imsweb.staging.entities.StagingMapping;
import com.imsweb.staging.entities.StagingSchema;
import com.imsweb.staging.entities.StagingSchemaInput;
import com.imsweb.staging.entities.StagingStringRange;
import com.imsweb.staging.entities.StagingTable;
import com.imsweb.staging.entities.StagingTablePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Staging {
    public static final String CTX_YEAR_CURRENT = "ctx_year_current";
    public static final List<String> CONTEXT_KEYS = Arrays.asList("ctx_year_current");
    private DecisionEngine _engine = null;
    private StagingDataProvider _provider = null;

    private Staging(StagingDataProvider provider) {
        this._provider = provider;
        this._engine = new DecisionEngine(provider);
    }

    public static Staging getInstance(StagingDataProvider provider) {
        return new Staging(provider);
    }

    public String getAlgorithm() {
        return this._provider.getAlgorithm();
    }

    public String getVersion() {
        return this._provider.getVersion();
    }

    public Set<String> getSchemaIds() {
        return this._provider.getSchemaIds();
    }

    public StagingSchema getSchema(String id) {
        return this._provider.getDefinition(id);
    }

    public boolean isValidSite(String site) {
        return this._provider.isValidSite(site);
    }

    public boolean isValidHistology(String histology) {
        return this._provider.isValidHistology(histology);
    }

    public List<StagingSchema> lookupSchema(SchemaLookup lookup) {
        return this._provider.lookupSchema(lookup);
    }

    public Set<String> getTableIds() {
        return this._provider.getTableIds();
    }

    public StagingTable getTable(String id) {
        return this._provider.getTable(id);
    }

    public boolean isCodeValid(String schemaId, String key, String value) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(key, value);
        this.addContextKeys(context);
        return this.isContextValid(schemaId, key, context);
    }

    public boolean isContextValid(String schemaId, String key, Map<String, String> context) {
        StagingSchema schema = this.getSchema(schemaId);
        if (schema == null) {
            return false;
        }
        StagingSchemaInput input = schema.getInputMap().get(key);
        if (input == null) {
            return false;
        }
        if (context == null || context.isEmpty()) {
            return false;
        }
        HashMap<String, String> testContext = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : context.entrySet()) {
            testContext.put(entry.getKey(), entry.getValue() != null ? entry.getValue().trim() : "");
        }
        if (input.getValues() != null && !input.getValues().isEmpty() && !DecisionEngine.testMatch(input.getValues(), (String)testContext.get(key), testContext)) {
            return false;
        }
        if (input.getTable() != null) {
            StagingTable table = this.getTable(input.getTable());
            if (table == null) {
                return false;
            }
            return DecisionEngine.matchTable(table, testContext) != null;
        }
        return true;
    }

    public Integer findMatchingTableRow(String tableId, String key, String value) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(key, value);
        return this.findMatchingTableRow(tableId, context);
    }

    public Integer findMatchingTableRow(String tableId, Map<String, String> context) {
        Integer rowIndex = null;
        this.addContextKeys(context);
        StagingTable table = this.getTable(tableId);
        if (table != null) {
            rowIndex = DecisionEngine.findMatchingTableRow(table, context);
        }
        return rowIndex;
    }

    public Set<String> getInvolvedTables(String schemaId) {
        Set<String> tables = new HashSet<String>();
        StagingSchema schema = this.getSchema(schemaId);
        if (schema != null && schema.getInvolvedTables() != null) {
            tables = schema.getInvolvedTables();
        }
        return tables;
    }

    public Set<String> getInvolvedSchemas(String tableId) {
        HashSet<String> schemas = new HashSet<String>();
        for (String schemaId : this.getSchemaIds()) {
            if (!this.getInvolvedTables(schemaId).contains(tableId)) continue;
            schemas.add(schemaId);
        }
        return schemas;
    }

    public Set<String> getInputs(StagingTablePath path) {
        return this.getInputs(path, new HashSet<String>());
    }

    public Set<String> getInputs(StagingTablePath path, Set<String> excludedInputs) {
        HashSet<String> inputs = new HashSet<String>();
        if (path != null) {
            inputs.addAll(this._engine.getInputs(path, excludedInputs));
        }
        inputs.removeAll(CONTEXT_KEYS);
        return inputs;
    }

    public Set<String> getInputs(StagingMapping mapping) {
        return this.getInputs(mapping, null, new HashSet<String>());
    }

    public Set<String> getInputs(StagingMapping mapping, Map<String, String> context, Set<String> excludedInputs) {
        HashSet<String> inputs = new HashSet<String>();
        if (mapping.getInclusionTables() != null) {
            for (StagingTablePath path : mapping.getInclusionTables()) {
                inputs.addAll(this.getInputs(path, excludedInputs));
            }
        }
        if (mapping.getExclusionTables() != null) {
            for (StagingTablePath path : mapping.getExclusionTables()) {
                inputs.addAll(this.getInputs(path, excludedInputs));
            }
        }
        if (mapping.getTablePaths() != null && (context == null || this._engine.isMappingInvolved(mapping, context))) {
            inputs.addAll(this._engine.getInputs(mapping, excludedInputs));
        }
        inputs.removeAll(CONTEXT_KEYS);
        return inputs;
    }

    public Set<String> getInputs(StagingSchema schema) {
        return this.getInputs(schema, null);
    }

    public Set<String> getInputs(StagingSchema schema, Map<String, String> context) {
        StagingTable table;
        HashSet<String> inputs = new HashSet<String>();
        if (schema.getSchemaSelectionTable() != null && (table = this.getTable(schema.getSchemaSelectionTable())) != null) {
            for (StagingColumnDefinition def : table.getColumnDefinitions()) {
                if (!ColumnDefinition.ColumnType.INPUT.equals((Object)def.getType())) continue;
                inputs.add(def.getKey());
            }
        }
        if (schema.getInputMap() != null) {
            for (Map.Entry<String, StagingSchemaInput> entry : schema.getInputMap().entrySet()) {
                StagingSchemaInput input = entry.getValue();
                if (input.getValues() == null) continue;
                for (StagingStringRange range : input.getValues()) {
                    if (DecisionEngine.isReferenceVariable(range.getLow())) {
                        inputs.add(DecisionEngine.trimBraces(range.getLow()));
                    }
                    if (!DecisionEngine.isReferenceVariable(range.getHigh())) continue;
                    inputs.add(DecisionEngine.trimBraces(range.getHigh()));
                }
            }
        }
        if (schema.getMappings() != null) {
            HashSet<String> excludedInputs = new HashSet<String>();
            for (StagingMapping mapping : schema.getMappings()) {
                inputs.addAll(this.getInputs(mapping, context, excludedInputs));
            }
        }
        inputs.removeAll(CONTEXT_KEYS);
        return inputs;
    }

    public Set<String> getOutputs(StagingTablePath path) {
        return this._engine.getOutputs(path);
    }

    public Set<String> getOutputs(StagingMapping mapping) {
        return this.getOutputs(mapping, null);
    }

    public Set<String> getOutputs(StagingMapping mapping, Map<String, String> context) {
        HashSet<String> outputs = new HashSet<String>();
        if (mapping.getTablePaths() != null && (context == null || this._engine.isMappingInvolved(mapping, context))) {
            outputs.addAll(this._engine.getOutputs(mapping));
        }
        return outputs;
    }

    public Set<String> getOutputs(StagingSchema schema) {
        return this.getOutputs(schema, null);
    }

    public Set<String> getOutputs(StagingSchema schema, Map<String, String> context) {
        HashSet<String> outputs = new HashSet<String>();
        if (schema.getMappings() != null) {
            for (StagingMapping mapping : schema.getMappings()) {
                outputs.addAll(this.getOutputs(mapping, context));
            }
        }
        return outputs;
    }

    public StagingData stage(StagingData data) {
        data.setSchemaId(null);
        data.setOutput(new HashMap<String, String>());
        data.setErrors(new ArrayList<Error>());
        data.setPath(new ArrayList<String>());
        if (data.getInput("site") == null || data.getInput("hist") == null) {
            data.setResult(StagingData.Result.FAILED_MISSING_SITE_OR_HISTOLOGY);
        } else {
            List<StagingSchema> schemas = this.lookupSchema(new SchemaLookup(data.getInput()));
            if (schemas.size() != 1) {
                if (schemas.size() == 0) {
                    data.setResult(StagingData.Result.FAILED_NO_MATCHING_SCHEMA);
                } else {
                    data.setResult(StagingData.Result.FAILED_MULITPLE_MATCHING_SCHEMAS);
                }
            } else {
                StagingSchema schema = schemas.get(0);
                data.setSchemaId(schema.getId());
                HashMap<String, String> context = new HashMap<String, String>();
                for (Map.Entry<String, String> entry : data.getInput().entrySet()) {
                    context.put(entry.getKey(), entry.getValue() != null ? entry.getValue().trim() : "");
                }
                this.addContextKeys(context);
                if (!this.isContextValid(schema.getId(), "year_dx", context)) {
                    data.setResult(StagingData.Result.FAILED_INVALID_YEAR_DX);
                } else {
                    Result result = this._engine.process(schemas.get(0).getId(), context);
                    this.removeContextKeys(context);
                    if (Result.Type.FAILED_INPUT.equals((Object)result.getType())) {
                        data.setResult(StagingData.Result.FAILED_INVALID_INPUT);
                    } else {
                        data.setResult(StagingData.Result.STAGED);
                    }
                    for (Map.Entry<String, String> entry : data.getInput().entrySet()) {
                        context.remove(entry.getKey());
                    }
                    for (StagingSchemaInput input : schemas.get(0).getInputs()) {
                        context.remove(input.getKey());
                    }
                    data.setOutput(result.getContext());
                    data.setErrors(result.getErrors());
                    data.setPath(result.getPath());
                }
            }
        }
        return data;
    }

    private Map<String, String> addContextKeys(Map<String, String> context) {
        Calendar now = Calendar.getInstance();
        context.put(CTX_YEAR_CURRENT, String.valueOf(now.get(1)));
        return context;
    }

    private Map<String, String> removeContextKeys(Map<String, String> context) {
        context.remove(CTX_YEAR_CURRENT);
        return context;
    }
}

