/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.imsweb.decisionengine.ColumnDefinition;
import com.imsweb.decisionengine.DataProvider;
import com.imsweb.decisionengine.DecisionEngine;
import com.imsweb.decisionengine.Endpoint;
import com.imsweb.staging.SchemaLookup;
import com.imsweb.staging.Staging;
import com.imsweb.staging.entities.StagingColumnDefinition;
import com.imsweb.staging.entities.StagingEndpoint;
import com.imsweb.staging.entities.StagingSchema;
import com.imsweb.staging.entities.StagingSchemaInput;
import com.imsweb.staging.entities.StagingStringRange;
import com.imsweb.staging.entities.StagingTable;
import com.imsweb.staging.entities.StagingTableRow;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class StagingDataProvider
implements DataProvider {
    public static final String PRIMARY_SITE_TABLE = "primary_site";
    public static final String HISTOLOGY_TABLE = "histology";
    private static final DateFormat _DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final ObjectMapper _MAPPER = new ObjectMapper();
    private static StagingStringRange _MATCH_ALL_ENDPOINT = new StagingStringRange();
    private LoadingCache<SchemaLookup, List<StagingSchema>> _lookupCache = CacheBuilder.newBuilder().maximumSize(500L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<SchemaLookup, List<StagingSchema>>(){

        public List<StagingSchema> load(SchemaLookup lookup) throws Exception {
            return StagingDataProvider.this.getSchemas(lookup);
        }
    });
    private LoadingCache<String, Set<String>> _validValuesCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Set<String>>(){

        public Set<String> load(String tableId) throws Exception {
            return StagingDataProvider.this.getAllInputValues(tableId);
        }
    });

    protected StagingDataProvider() {
    }

    public void invalidateCache() {
        this._lookupCache.invalidateAll();
        this._validValuesCache.invalidateAll();
    }

    public static StagingSchema initSchema(StagingSchema schema) {
        if (schema.getSchemaSelectionTable() == null) {
            throw new IllegalStateException("Schemas must have a schema selection table.");
        }
        if (schema.getInputs() != null) {
            HashMap<String, StagingSchemaInput> parsedInputMap = new HashMap<String, StagingSchemaInput>();
            for (StagingSchemaInput input : schema.getInputs()) {
                if (input.getKey() == null) {
                    throw new IllegalStateException("All input definitions must have a 'key' value defined.");
                }
                StagingSchemaInput inputCopy = new StagingSchemaInput(input);
                if (inputCopy.getRawValues() != null) {
                    inputCopy.setValues(StagingDataProvider.splitValues(inputCopy.getRawValues()));
                }
                parsedInputMap.put(inputCopy.getKey(), inputCopy);
                schema.setInputMap(parsedInputMap);
            }
        }
        return schema;
    }

    public static StagingTable initTable(StagingTable table) {
        HashSet<String> extraInputs = new HashSet<String>();
        if (table.getRawRows() != null) {
            for (List<String> row : table.getRawRows()) {
                StagingTableRow tableRowEntity = new StagingTableRow();
                if (table.getColumnDefinitions().size() != row.size()) {
                    throw new IllegalStateException("Table '" + table.getId() + "' has a row with " + row.size() + " values but should have " + table.getColumnDefinitions().size() + ": " + row);
                }
                block6: for (int i = 0; i < table.getColumnDefinitions().size(); ++i) {
                    StagingColumnDefinition col = table.getColumnDefinitions().get(i);
                    String cellValue = row.get(i);
                    switch (col.getType()) {
                        case INPUT: {
                            List<StagingStringRange> ranges = StagingDataProvider.splitValues(cellValue);
                            if (ranges.isEmpty()) continue block6;
                            tableRowEntity.addInput(col.getKey(), ranges);
                            for (StagingStringRange range : ranges) {
                                if (DecisionEngine.isReferenceVariable(range.getLow())) {
                                    extraInputs.add(DecisionEngine.trimBraces(range.getLow()));
                                }
                                if (!DecisionEngine.isReferenceVariable(range.getHigh())) continue;
                                extraInputs.add(DecisionEngine.trimBraces(range.getHigh()));
                            }
                            continue block6;
                        }
                        case ENDPOINT: {
                            StagingEndpoint endpoint = StagingDataProvider.parseEndpoint(cellValue);
                            if (Endpoint.EndpointType.VALUE.equals((Object)endpoint.getType())) {
                                endpoint.setResultKey(col.getKey());
                            }
                            tableRowEntity.addEndpoint(endpoint);
                            if (!Endpoint.EndpointType.VALUE.equals((Object)endpoint.getType()) || !DecisionEngine.isReferenceVariable(endpoint.getValue())) continue block6;
                            extraInputs.add(DecisionEngine.trimBraces(endpoint.getValue()));
                            continue block6;
                        }
                        case DESCRIPTION: {
                            continue block6;
                        }
                        default: {
                            throw new IllegalStateException("Table '" + table.getId() + " has an unknown column type: '" + (Object)((Object)col.getType()) + "'");
                        }
                    }
                }
                table.getTableRows().add(tableRowEntity);
            }
        }
        extraInputs.removeAll(Staging.CONTEXT_KEYS);
        table.setExtraInput(extraInputs.isEmpty() ? null : extraInputs);
        return table;
    }

    public boolean isValidSite(String site) {
        boolean valid;
        boolean bl = valid = site != null;
        if (valid) {
            StagingTable table = this.getTable(PRIMARY_SITE_TABLE);
            if (table == null) {
                throw new IllegalStateException("Unable to locate primary_site table");
            }
            valid = this.getValidSites().contains(site);
        }
        return valid;
    }

    public boolean isValidHistology(String histology) {
        boolean valid;
        boolean bl = valid = histology != null;
        if (valid) {
            StagingTable table = this.getTable(HISTOLOGY_TABLE);
            if (table == null) {
                throw new IllegalStateException("Unable to locate histology table");
            }
            valid = this.getValidHistologies().contains(histology);
        }
        return valid;
    }

    public static StagingEndpoint parseEndpoint(String endpoint) {
        String value;
        String[] parts = endpoint.split(":", 2);
        Endpoint.EndpointType type = null;
        try {
            type = Endpoint.EndpointType.valueOf(parts[0].trim());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (type == null) {
            throw new IllegalStateException("Invalid endpoint type: '" + endpoint + "'.  Must be either JUMP, VALUE, MATCH, STOP, or ERROR");
        }
        String string = value = parts.length == 2 ? parts[1].trim() : null;
        if ((value == null || value.isEmpty()) && Endpoint.EndpointType.JUMP.equals((Object)type)) {
            throw new IllegalStateException("JUMP endpoint types must have a value: '" + endpoint + "'");
        }
        return new StagingEndpoint(type, value);
    }

    public static List<StagingStringRange> splitValues(String values) {
        ArrayList<StagingStringRange> convertedRanges = new ArrayList<StagingStringRange>();
        if (values != null) {
            if (values.equals("*")) {
                convertedRanges.add(_MATCH_ALL_ENDPOINT);
            } else {
                String[] ranges;
                for (String range : ranges = values.split(",")) {
                    String[] parts = range.split("-");
                    if (parts.length == 1) {
                        convertedRanges.add(new StagingStringRange(parts[0].trim(), parts[0].trim()));
                        continue;
                    }
                    if (parts.length == 2) {
                        if (parts[0].trim().length() != parts[1].trim().length() && !DecisionEngine.isReferenceVariable(parts[0].trim()) && !DecisionEngine.isReferenceVariable(parts[1].trim())) {
                            convertedRanges.add(new StagingStringRange(range.trim(), range.trim()));
                            continue;
                        }
                        convertedRanges.add(new StagingStringRange(parts[0].trim(), parts[1].trim()));
                        continue;
                    }
                    convertedRanges.add(new StagingStringRange(range.trim(), range.trim()));
                }
            }
        }
        return convertedRanges;
    }

    public ObjectMapper getMapper() {
        return _MAPPER;
    }

    public abstract String getAlgorithm();

    public abstract String getVersion();

    @Override
    public abstract StagingTable getTable(String var1);

    @Override
    public abstract StagingSchema getDefinition(String var1);

    public abstract Set<String> getSchemaIds();

    public abstract Set<String> getTableIds();

    public Set<String> getValidSites() {
        try {
            return (Set)this._validValuesCache.get((Object)PRIMARY_SITE_TABLE);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
        catch (UncheckedExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    public Set<String> getValidHistologies() {
        try {
            return (Set)this._validValuesCache.get((Object)HISTOLOGY_TABLE);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
        catch (UncheckedExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    public List<StagingSchema> lookupSchema(SchemaLookup lookup) {
        if (lookup.getSite() == null || lookup.getHistology() == null) {
            return this.getSchemas(lookup);
        }
        try {
            return (List)this._lookupCache.get((Object)lookup);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
        catch (UncheckedExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    private List<StagingSchema> getSchemas(SchemaLookup lookup) {
        ArrayList<StagingSchema> matchedSchemas = new ArrayList<StagingSchema>();
        String site = lookup.getInput("site");
        String histology = lookup.getInput("hist");
        boolean hasDiscriminator = lookup.hasDiscriminator();
        if (site != null && !this.isValidSite(site) || histology != null && !this.isValidHistology(histology)) {
            return matchedSchemas;
        }
        if (hasDiscriminator && (site == null || site.isEmpty() || histology == null || histology.isEmpty())) {
            return matchedSchemas;
        }
        if (site != null || histology != null) {
            StagingTable table;
            HashSet<String> keysToMatch = new HashSet<String>();
            if (site != null) {
                keysToMatch.add("site");
            }
            if (histology != null) {
                keysToMatch.add("hist");
            }
            for (String schemaId : this.getSchemaIds()) {
                StagingSchema schema = this.getDefinition(schemaId);
                if (schema.getSchemaSelectionTable() == null || (table = this.getTable(schema.getSchemaSelectionTable())) == null || DecisionEngine.matchTable(table, lookup.getInputs(), keysToMatch) == null) continue;
                matchedSchemas.add(schema);
            }
            if (hasDiscriminator && matchedSchemas.size() > 1) {
                ArrayList<StagingSchema> trimmedMatches = new ArrayList<StagingSchema>();
                for (StagingSchema schema : matchedSchemas) {
                    if (schema.getSchemaSelectionTable() == null || (table = this.getTable(schema.getSchemaSelectionTable())) == null || DecisionEngine.matchTable(table, lookup.getInputs()) == null) continue;
                    trimmedMatches.add(schema);
                }
                matchedSchemas = trimmedMatches;
            }
        }
        return matchedSchemas;
    }

    private Set<String> getAllInputValues(String tableId) {
        HashSet<String> values = new HashSet<String>();
        StagingTable table = this.getTable(tableId);
        if (table == null) {
            return values;
        }
        HashSet<String> inputKeys = new HashSet<String>();
        for (StagingColumnDefinition def : table.getColumnDefinitions()) {
            if (!ColumnDefinition.ColumnType.INPUT.equals((Object)def.getType())) continue;
            inputKeys.add(def.getKey());
        }
        if (inputKeys.size() != 1) {
            throw new IllegalStateException("Table '" + table.getId() + "' must have one and only one INPUT column.");
        }
        String inputKey = (String)inputKeys.iterator().next();
        for (StagingTableRow row : table.getTableRows()) {
            for (StagingStringRange range : row.getColumnInput(inputKey)) {
                if (range.getLow() == null) continue;
                if (range.getLow().equals(range.getHigh())) {
                    values.add(range.getLow());
                    continue;
                }
                Integer low = Integer.parseInt(range.getLow());
                Integer high = Integer.parseInt(range.getHigh());
                Integer i = low;
                while (i <= high) {
                    values.add(Strings.padStart((String)String.valueOf(i), (int)range.getLow().length(), (char)'0'));
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            }
        }
        return values;
    }

    static {
        _DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        _MAPPER.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        _MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        _MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        _MAPPER.setDateFormat(_DATE_FORMAT);
        _MAPPER.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        _MAPPER.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.ANY);
    }
}

