/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Objects;
import com.imsweb.decisionengine.Definition;
import com.imsweb.staging.entities.StagingKeyValue;
import com.imsweb.staging.entities.StagingMapping;
import com.imsweb.staging.entities.StagingSchemaInput;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Embedded;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.Indexed;
import org.mongodb.morphia.annotations.Property;

@JsonPropertyOrder(value={"id", "algorithm", "version", "name", "title", "subtitle", "description", "notes", "schema_num", "schema_selection_table", "schema_discriminators", "initial_context", "inputs", "mappings", "involved_tables", "last_modified"})
@Entity(value="staging_schemas", noClassnameStored=true)
public class StagingSchema
implements Definition {
    @Id
    private ObjectId _id;
    @Indexed
    @Property(value="id")
    private String _displayId;
    @Indexed
    @Property(value="algorithm")
    private String _algorithm;
    @Indexed
    @Property(value="version")
    private String _version;
    @Property(value="name")
    private String _name;
    @Property(value="title")
    private String _title;
    @Property(value="description")
    private String _description;
    @Property(value="subtitle")
    private String _subtitle;
    @Property(value="notes")
    private String _notes;
    @Property(value="modified")
    private Date _lastModified;
    @Property(value="schema_num")
    private Integer _schemaNum;
    @Embedded(value="schema_selection_table")
    private String _schemaSelectionTable;
    @Embedded(value="schema_discriminators")
    private Set<String> _schemaDiscriminators;
    @Embedded(value="inputs")
    private List<StagingSchemaInput> _inputs;
    @Embedded(value="initial_context")
    private List<StagingKeyValue> _initialContext;
    @Embedded(value="mappings")
    private List<StagingMapping> _mappings;
    @Property(value="involved_tables")
    private Set<String> _involvedTables;
    @Embedded(value="parsed_input_map")
    private Map<String, StagingSchemaInput> _parsedInputMap = new HashMap<String, StagingSchemaInput>();

    @JsonIgnore
    public ObjectId getInternalId() {
        return this._id;
    }

    public void setInternalId(ObjectId id) {
        this._id = id;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this._displayId;
    }

    public void setId(String id) {
        this._displayId = id;
    }

    @JsonProperty(value="algorithm")
    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this._algorithm = algorithm;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @JsonProperty(value="subtitle")
    public String getSubtitle() {
        return this._subtitle;
    }

    public void setSubtitle(String subtitle) {
        this._subtitle = subtitle;
    }

    @JsonProperty(value="notes")
    public String getNotes() {
        return this._notes;
    }

    public void setNotes(String notes) {
        this._notes = notes;
    }

    @JsonProperty(value="last_modified")
    public Date getLastModified() {
        return this._lastModified;
    }

    public void setLastModified(Date lastModified) {
        this._lastModified = lastModified;
    }

    @JsonProperty(value="schema_num")
    public Integer getSchemaNum() {
        return this._schemaNum;
    }

    public void setSchemaNum(Integer schemaNum) {
        this._schemaNum = schemaNum;
    }

    @JsonProperty(value="schema_selection_table")
    public String getSchemaSelectionTable() {
        return this._schemaSelectionTable;
    }

    public void setSchemaSelectionTable(String schemaSelectionTable) {
        this._schemaSelectionTable = schemaSelectionTable;
    }

    @JsonProperty(value="schema_discriminators")
    public Set<String> getSchemaDiscriminators() {
        return this._schemaDiscriminators;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setSchemaDiscriminators(Set<String> schemaDiscriminators) {
        this._schemaDiscriminators = schemaDiscriminators;
    }

    @JsonProperty(value="inputs")
    public List<StagingSchemaInput> getInputs() {
        return this._inputs;
    }

    public void setInputs(List<StagingSchemaInput> inputs) {
        this._inputs = inputs;
    }

    @JsonProperty(value="initial_context")
    public List<StagingKeyValue> getInitialContext() {
        return this._initialContext;
    }

    public void setInitialContext(List<StagingKeyValue> initialContext) {
        this._initialContext = initialContext;
    }

    @JsonProperty(value="mappings")
    public List<StagingMapping> getMappings() {
        return this._mappings;
    }

    public void setMappings(List<StagingMapping> mapping) {
        this._mappings = mapping;
    }

    @JsonIgnore
    public Map<String, StagingSchemaInput> getInputMap() {
        return this._parsedInputMap;
    }

    public void setInputMap(Map<String, StagingSchemaInput> parsedInputMap) {
        this._parsedInputMap = parsedInputMap;
    }

    @JsonProperty(value="involved_tables")
    public Set<String> getInvolvedTables() {
        return this._involvedTables;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setInvolvedTables(Set<String> involvedTables) {
        this._involvedTables = involvedTables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StagingSchema schema = (StagingSchema)o;
        return Objects.equal((Object)this._displayId, (Object)schema._displayId) && Objects.equal((Object)this._algorithm, (Object)schema._algorithm) && Objects.equal((Object)this._version, (Object)schema._version) && Objects.equal((Object)this._name, (Object)schema._name) && Objects.equal((Object)this._title, (Object)schema._title) && Objects.equal((Object)this._description, (Object)schema._description) && Objects.equal((Object)this._subtitle, (Object)schema._subtitle) && Objects.equal((Object)this._notes, (Object)schema._notes) && Objects.equal((Object)this._schemaNum, (Object)schema._schemaNum) && Objects.equal((Object)this._schemaSelectionTable, (Object)schema._schemaSelectionTable) && Objects.equal(this._schemaDiscriminators, schema._schemaDiscriminators) && Objects.equal(this._inputs, schema._inputs) && Objects.equal(this._initialContext, schema._initialContext) && Objects.equal(this._mappings, schema._mappings) && Objects.equal(this._involvedTables, schema._involvedTables);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._displayId, this._algorithm, this._version, this._name, this._title, this._description, this._subtitle, this._notes, this._schemaNum, this._schemaSelectionTable, this._schemaDiscriminators, this._inputs, this._initialContext, this._mappings, this._involvedTables});
    }
}

