/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Date;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.Indexed;
import org.mongodb.morphia.annotations.Property;

@JsonPropertyOrder(value={"algorithm", "version", "type", "last_modified"})
@Entity(value="staging_versions", noClassnameStored=true)
public class StagingVersion {
    @Id
    private ObjectId _id;
    @Indexed
    @Property(value="algorithm")
    private String _algorithm;
    @Indexed
    @Property(value="version")
    private String _version;
    @Property(value="type")
    private Type _type;
    @Property(value="modified")
    private Date _lastModified;

    public StagingVersion() {
    }

    public StagingVersion(String algorithm, String version) {
        this.setAlgorithm(algorithm);
        this.setVersion(version);
    }

    @JsonIgnore
    public ObjectId getId() {
        return this._id;
    }

    public void setId(ObjectId id) {
        this._id = id;
    }

    @JsonProperty(value="algorithm")
    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this._algorithm = algorithm;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this._type;
    }

    public void setType(Type type) {
        this._type = type;
    }

    @JsonProperty(value="last_modified")
    public Date getLastModified() {
        return this._lastModified;
    }

    public void setLastModified(Date lastModified) {
        this._lastModified = lastModified;
    }

    @JsonIgnore
    public boolean isProduction() {
        return Type.PRODUCTION.equals((Object)this.getType());
    }

    @JsonIgnore
    public boolean isBeta() {
        return Type.BETA.equals((Object)this.getType());
    }

    @JsonIgnore
    public boolean isDevelopment() {
        return Type.DEVELOPMENT.equals((Object)this.getType());
    }

    public static enum Type {
        PRODUCTION,
        BETA,
        DEVELOPMENT;

    }
}

