/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.decisionengine;

import com.google.common.base.Joiner;
import com.imsweb.decisionengine.ColumnDefinition;
import com.imsweb.decisionengine.DataProvider;
import com.imsweb.decisionengine.Definition;
import com.imsweb.decisionengine.Endpoint;
import com.imsweb.decisionengine.Error;
import com.imsweb.decisionengine.Input;
import com.imsweb.decisionengine.KeyMapping;
import com.imsweb.decisionengine.KeyValue;
import com.imsweb.decisionengine.Mapping;
import com.imsweb.decisionengine.Result;
import com.imsweb.decisionengine.StringRange;
import com.imsweb.decisionengine.Table;
import com.imsweb.decisionengine.TablePath;
import com.imsweb.decisionengine.TableRow;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DecisionEngine {
    private static Pattern _TEMPLATE_REFERENCE = Pattern.compile("\\{\\{(.*?)\\}\\}");
    public static String _BLANK_OUTPUT = "<blank>";
    protected DataProvider _provider;

    public DecisionEngine(DataProvider provider) {
        this.setProvider(provider);
    }

    public static boolean isReferenceVariable(String value) {
        return value != null && value.startsWith("{{") && value.endsWith("}}");
    }

    public static String trimBraces(String value) {
        if (value.length() > 3) {
            return value.substring(2, value.length() - 2);
        }
        return value;
    }

    public static List<? extends Endpoint> matchTable(Table table, Map<String, String> context) {
        return DecisionEngine.matchTable(table, context, null);
    }

    public static List<? extends Endpoint> matchTable(Table table, Map<String, String> context, Set<String> keysToMatch) {
        List<? extends Endpoint> endpoints = null;
        Integer index = DecisionEngine.findMatchingTableRow(table, context, keysToMatch);
        if (index != null) {
            endpoints = table.getTableRows().get(index).getEndpoints();
        }
        return endpoints;
    }

    public static Integer findMatchingTableRow(Table table, Map<String, String> context) {
        return DecisionEngine.findMatchingTableRow(table, context, null);
    }

    public static Integer findMatchingTableRow(Table table, Map<String, String> context, Set<String> keysToMatch) {
        Integer rowIndex = null;
        if (context == null) {
            throw new IllegalStateException("Context must not be missing");
        }
        for (int i = 0; i < table.getTableRows().size(); ++i) {
            boolean matchAll = true;
            for (ColumnDefinition columnDefinition : table.getColumnDefinitions()) {
                if (ColumnDefinition.ColumnType.INPUT.equals((Object)columnDefinition.getType()) && (keysToMatch == null || keysToMatch.contains(columnDefinition.getKey()))) {
                    matchAll = DecisionEngine.testMatch(table.getTableRows().get(i).getColumnInput(columnDefinition.getKey()), context.get(columnDefinition.getKey()), context);
                }
                if (matchAll) continue;
                break;
            }
            if (!matchAll) continue;
            rowIndex = i;
            break;
        }
        return rowIndex;
    }

    public static boolean testMatch(List<? extends StringRange> values, String value, Map<String, String> context) {
        boolean match;
        block1: {
            StringRange range;
            boolean bl = match = values == null || values.isEmpty();
            if (match) break block1;
            Iterator<? extends StringRange> i$ = values.iterator();
            while (i$.hasNext() && !(match = (range = i$.next()).contains(value, context))) {
            }
        }
        return match;
    }

    public static String translateValue(String value, Map<String, String> context) {
        Matcher m;
        if (value != null && value.startsWith("{{") && (m = _TEMPLATE_REFERENCE.matcher(value)).matches()) {
            String referencedKey = m.group(1);
            value = context.containsKey(referencedKey) ? context.get(referencedKey) : "";
        }
        return value;
    }

    public DataProvider getProvider() {
        return this._provider;
    }

    public void setProvider(DataProvider provider) {
        this._provider = provider;
    }

    public boolean isMappingInvolved(Mapping mapping, Map<String, String> context) {
        Table table;
        HashMap<String, String> pathContext;
        if (context == null) {
            throw new IllegalStateException("Context must not be missing");
        }
        boolean matches = true;
        if (mapping.getInclusionTables() != null) {
            for (TablePath tablePath : mapping.getInclusionTables()) {
                pathContext = new HashMap<String, String>();
                pathContext.putAll(context);
                table = this.getProvider().getTable(tablePath.getId());
                if (table == null) {
                    throw new IllegalStateException("Inclusion table '" + tablePath.getId() + "' does not exist");
                }
                if (tablePath.getInputMapping() != null) {
                    for (KeyMapping keyMapping : tablePath.getInputMapping()) {
                        if (!pathContext.containsKey(keyMapping.getFrom())) continue;
                        pathContext.put(keyMapping.getTo(), (String)pathContext.get(keyMapping.getFrom()));
                    }
                }
                if (matches = DecisionEngine.matchTable(table, pathContext) != null) continue;
                break;
            }
        }
        if (matches && mapping.getExclusionTables() != null) {
            for (TablePath tablePath : mapping.getExclusionTables()) {
                pathContext = new HashMap();
                pathContext.putAll(context);
                table = this.getProvider().getTable(tablePath.getId());
                if (table == null) {
                    throw new IllegalStateException("Exclusion table '" + tablePath.getId() + "' does not exist");
                }
                if (tablePath.getInputMapping() != null) {
                    for (KeyMapping keyMapping : tablePath.getInputMapping()) {
                        if (!pathContext.containsKey(keyMapping.getFrom())) continue;
                        pathContext.put(keyMapping.getTo(), (String)pathContext.get(keyMapping.getFrom()));
                    }
                }
                if (matches = DecisionEngine.matchTable(table, pathContext) == null) continue;
                break;
            }
        }
        return matches;
    }

    public List<Mapping> getInvolvedMappings(Definition definition, Map<String, String> context) {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        if (context == null) {
            throw new IllegalStateException("Context must not be missing");
        }
        if (definition.getMappings() != null) {
            for (Mapping mapping : definition.getMappings()) {
                if (!this.isMappingInvolved(mapping, context)) continue;
                mappings.add(mapping);
            }
        }
        return mappings;
    }

    public Set<String> getInvolvedTables(String definitionId) {
        Definition definition = this.getProvider().getDefinition(definitionId);
        if (definition == null) {
            throw new IllegalStateException("Unknown starting table: '" + definitionId + "'");
        }
        return this.getInvolvedTables(definition);
    }

    public Set<String> getInvolvedTables(Definition definition) {
        LinkedHashSet<String> tables = new LinkedHashSet<String>();
        for (String string : definition.getInputMap().keySet()) {
            Input input = definition.getInputMap().get(string);
            if (input.getTable() == null) continue;
            this.getInvolvedTables(this.getProvider().getTable(input.getTable()), tables);
        }
        if (definition.getMappings() != null) {
            for (Mapping mapping : definition.getMappings()) {
                if (mapping.getInclusionTables() != null) {
                    for (TablePath tablePath : mapping.getInclusionTables()) {
                        this.getInvolvedTables(this.getProvider().getTable(tablePath.getId()), tables);
                    }
                }
                if (mapping.getExclusionTables() != null) {
                    for (TablePath tablePath : mapping.getExclusionTables()) {
                        this.getInvolvedTables(this.getProvider().getTable(tablePath.getId()), tables);
                    }
                }
                if (mapping.getTablePaths() == null) continue;
                for (TablePath tablePath : mapping.getTablePaths()) {
                    this.getInvolvedTables(this.getProvider().getTable(tablePath.getId()), tables);
                }
            }
        }
        return tables;
    }

    protected Set<String> getInvolvedTables(Table table, Set<String> tables) {
        if (table == null) {
            return tables;
        }
        if (table.getTableRows() == null || table.getTableRows().isEmpty()) {
            throw new IllegalStateException("Table not initialized");
        }
        tables.add(table.getId());
        for (TableRow tableRow : table.getTableRows()) {
            for (Endpoint endpoint : tableRow.getEndpoints()) {
                if (endpoint == null || !Endpoint.EndpointType.JUMP.equals((Object)endpoint.getType()) || tables.contains(endpoint.getValue())) continue;
                this.getInvolvedTables(this.getProvider().getTable(endpoint.getValue()), tables);
            }
        }
        return tables;
    }

    public Set<String> getInputs(TablePath path) {
        return this.getInputs(path, new HashSet<String>());
    }

    public Set<String> getInputs(TablePath path, Set<String> excludedInputs) {
        LinkedHashSet<String> inputs = new LinkedHashSet<String>();
        if (path != null) {
            HashMap<String, String> inputMappings = new HashMap<String, String>();
            if (path.getInputMapping() != null) {
                for (KeyMapping keyMapping : path.getInputMapping()) {
                    inputMappings.put(keyMapping.getTo(), keyMapping.getFrom());
                }
            }
            HashMap<String, String> outputMappings = new HashMap<String, String>();
            if (path.getOutputMapping() != null) {
                for (KeyMapping keyMapping : path.getOutputMapping()) {
                    outputMappings.put(keyMapping.getFrom(), keyMapping.getTo());
                }
            }
            for (String string : this.getInvolvedTables(this.getProvider().getTable(path.getId()), new HashSet<String>())) {
                Table table = this.getProvider().getTable(string);
                if (table == null) continue;
                if (table.getColumnDefinitions() != null) {
                    for (ColumnDefinition columnDefinition : table.getColumnDefinitions()) {
                        String outputKey;
                        if (ColumnDefinition.ColumnType.INPUT.equals((Object)columnDefinition.getType())) {
                            String inputKey = inputMappings.containsKey(columnDefinition.getKey()) ? (String)inputMappings.get(columnDefinition.getKey()) : columnDefinition.getKey();
                            if (excludedInputs.contains(inputKey)) continue;
                            inputs.add(inputKey);
                            continue;
                        }
                        if (!ColumnDefinition.ColumnType.ENDPOINT.equals((Object)columnDefinition.getType()) || inputs.contains(outputKey = outputMappings.containsKey(columnDefinition.getKey()) ? (String)outputMappings.get(columnDefinition.getKey()) : columnDefinition.getKey())) continue;
                        excludedInputs.add(outputKey);
                    }
                }
                if (table.getExtraInput() == null) continue;
                for (String string2 : table.getExtraInput()) {
                    if (excludedInputs.contains(string2)) continue;
                    inputs.add(string2);
                }
            }
        }
        return inputs;
    }

    public Set<String> getInputs(Mapping mapping, Set<String> excludedInputs) {
        LinkedHashSet<String> inputs = new LinkedHashSet<String>();
        if (mapping.getInclusionTables() != null) {
            for (TablePath tablePath : mapping.getInclusionTables()) {
                inputs.addAll(this.getInputs(tablePath, excludedInputs));
            }
        }
        if (mapping.getExclusionTables() != null) {
            for (TablePath tablePath : mapping.getExclusionTables()) {
                inputs.addAll(this.getInputs(tablePath, excludedInputs));
            }
        }
        if (mapping.getTablePaths() != null) {
            for (TablePath tablePath : mapping.getTablePaths()) {
                inputs.addAll(this.getInputs(tablePath, excludedInputs));
            }
        }
        return inputs;
    }

    public Set<String> getInputs(Definition definition) {
        LinkedHashSet<String> inputs = new LinkedHashSet<String>();
        HashSet<String> excludedInputs = new HashSet<String>();
        if (definition.getMappings() != null) {
            for (Mapping mapping : definition.getMappings()) {
                inputs.addAll(this.getInputs(mapping, excludedInputs));
            }
        }
        return inputs;
    }

    public Set<String> getOutputs(TablePath path) {
        LinkedHashSet<String> outputs = new LinkedHashSet<String>();
        if (path != null) {
            HashMap<String, String> mappings = new HashMap<String, String>();
            if (path.getOutputMapping() != null) {
                for (KeyMapping keyMapping : path.getOutputMapping()) {
                    mappings.put(keyMapping.getFrom(), keyMapping.getTo());
                }
            }
            for (String string : this.getInvolvedTables(this.getProvider().getTable(path.getId()), new HashSet<String>())) {
                Table table = this.getProvider().getTable(string);
                if (table == null || table.getColumnDefinitions() == null) continue;
                for (ColumnDefinition columnDefinition : table.getColumnDefinitions()) {
                    if (!ColumnDefinition.ColumnType.ENDPOINT.equals((Object)columnDefinition.getType()) || columnDefinition.getKey() == null) continue;
                    outputs.add(mappings.containsKey(columnDefinition.getKey()) ? (String)mappings.get(columnDefinition.getKey()) : columnDefinition.getKey());
                }
            }
        }
        return outputs;
    }

    public Set<String> getOutputs(Mapping mapping) {
        LinkedHashSet<String> outputs = new LinkedHashSet<String>();
        if (mapping.getTablePaths() != null) {
            for (TablePath tablePath : mapping.getTablePaths()) {
                outputs.addAll(this.getOutputs(tablePath));
            }
        }
        return outputs;
    }

    public Set<String> getOutputs(Definition definition) {
        LinkedHashSet<String> outputs = new LinkedHashSet<String>();
        if (definition.getMappings() != null) {
            for (Mapping mapping : definition.getMappings()) {
                outputs.addAll(this.getOutputs(mapping));
            }
        }
        return outputs;
    }

    public Result process(String definitionId, Map<String, String> context) {
        Definition start = this.getProvider().getDefinition(definitionId);
        if (start == null) {
            throw new IllegalStateException("Unknown definition: '" + definitionId + "'");
        }
        return this.process(start, context);
    }

    /*
     * WARNING - void declaration
     */
    public Result process(Definition definition, Map<String, String> context) {
        Result result = new Result(context);
        for (Map.Entry<String, String> entry : context.entrySet()) {
            if (entry.getValue() == null) continue;
            context.put(entry.getKey(), entry.getValue().trim());
        }
        boolean stopForBadInput = false;
        for (String string : definition.getInputMap().keySet()) {
            void var8_13;
            Input input = definition.getInputMap().get(string);
            String string2 = context.get(input.getKey());
            if (string2 == null) {
                String string3 = input.getDefault() != null ? input.getDefault() : "";
                context.put(input.getKey(), string3);
            }
            if (input.getTable() == null) continue;
            Table lookup = this.getProvider().getTable(input.getTable());
            if (lookup == null) {
                result.addError(new Error.ErrorBuilder(Error.Type.UNKNOWN_TABLE).message("Input table does not exist: " + input.getTable()).key(input.getKey()).build());
                continue;
            }
            List<? extends Endpoint> endpoints = DecisionEngine.matchTable(lookup, context);
            if (endpoints != null) continue;
            result.addError(new Error.ErrorBuilder(Boolean.TRUE.equals(input.getUsedForStaging()) ? Error.Type.INVALID_REQUIRED_INPUT : Error.Type.INVALID_NON_REQUIRED_INPUT).message("Invalid '" + input.getKey() + "' value (" + (String)(var8_13.isEmpty() ? _BLANK_OUTPUT : var8_13) + ")").key(input.getKey()).table(input.getTable()).build());
            if (!Definition.StagingInputErrorHandler.FAIL.equals((Object)definition.getOnInvalidInput()) && (!Boolean.TRUE.equals(input.getUsedForStaging()) || !Definition.StagingInputErrorHandler.FAIL_WHEN_USED_FOR_STAGING.equals((Object)definition.getOnInvalidInput()))) continue;
            stopForBadInput = true;
        }
        if (stopForBadInput) {
            result.setType(Result.Type.FAILED_INPUT);
            return result;
        }
        if (definition.getInitialContext() != null) {
            for (KeyValue keyValue : definition.getInitialContext()) {
                context.put(keyValue.getKey(), keyValue.getValue());
            }
        }
        if (definition.getMappings() != null) {
            block3: for (Mapping mapping : definition.getMappings()) {
                if (!this.isMappingInvolved(mapping, context)) continue;
                if (mapping.getInclusionTables() != null) {
                    for (TablePath tablePath : mapping.getInclusionTables()) {
                        result.addPath(mapping.getId(), tablePath.getId());
                    }
                }
                if (mapping.getExclusionTables() != null) {
                    for (TablePath tablePath : mapping.getExclusionTables()) {
                        result.addPath(mapping.getId(), tablePath.getId());
                    }
                }
                if (mapping.getInitialContext() != null) {
                    for (KeyValue keyValue : mapping.getInitialContext()) {
                        context.put(keyValue.getKey(), keyValue.getValue());
                    }
                }
                if (mapping.getTablePaths() == null) continue;
                for (TablePath tablePath : mapping.getTablePaths()) {
                    String tableId = tablePath.getId();
                    if (tablePath.getInputMapping() != null) {
                        for (KeyMapping keyMapping : tablePath.getInputMapping()) {
                            String mapFromKey = keyMapping.getFrom();
                            if (!context.containsKey(mapFromKey)) {
                                result.addError(new Error.ErrorBuilder(Error.Type.UNKNOWN_INPUT_MAPPING).message("Input mapping '" + mapFromKey + "' does not exist for table '" + tableId + "'").key(mapFromKey).table(tableId).build());
                                continue;
                            }
                            context.put(keyMapping.getTo(), context.get(mapFromKey));
                        }
                    }
                    ArrayDeque<String> stack = new ArrayDeque<String>();
                    boolean bl = this.process(mapping.getId(), tableId, tablePath, result, stack);
                    if (tablePath.getInputMapping() != null) {
                        for (KeyMapping keyMapping : tablePath.getInputMapping()) {
                            context.remove(keyMapping.getTo());
                        }
                    }
                    if (bl) continue;
                    continue block3;
                }
            }
        }
        return result;
    }

    protected boolean process(String mappingId, String tableId, TablePath path, Result result, Deque<String> stack) {
        boolean continueProcessing = true;
        Table table = this.getProvider().getTable(tableId);
        if (table == null) {
            result.addError(new Error.ErrorBuilder(Error.Type.UNKNOWN_TABLE).message("The processing of '" + path.getId() + "' contains a reference to an unknown table: '" + tableId + "'").table(tableId).build());
            return true;
        }
        if (stack.contains(tableId)) {
            result.addError(new Error.ErrorBuilder(Error.Type.INFINITE_LOOP).message("The processing of '" + path.getId() + "' has entered an infinite recursive state.  Table '" + tableId + "' was accessed multiple times.").table(tableId).build());
            return true;
        }
        result.addPath(mappingId, tableId);
        stack.push(tableId);
        List<? extends Endpoint> endpoints = DecisionEngine.matchTable(table, result.getContext());
        if (endpoints == null) {
            result.addError(new Error.ErrorBuilder(Error.Type.MATCH_NOT_FOUND).message("Match not found in table '" + tableId + "' (" + DecisionEngine.getTableInputsAsString(table, result.getContext()) + ")").table(tableId).build());
        } else {
            for (Endpoint endpoint : endpoints) {
                if (Endpoint.EndpointType.STOP.equals((Object)endpoint.getType())) {
                    continueProcessing = false;
                    continue;
                }
                if (Endpoint.EndpointType.JUMP.equals((Object)endpoint.getType())) {
                    continueProcessing = this.process(mappingId, endpoint.getValue(), path, result, stack);
                    continue;
                }
                if (Endpoint.EndpointType.ERROR.equals((Object)endpoint.getType())) {
                    String message = endpoint.getValue();
                    if (message == null || message.isEmpty()) {
                        message = "Matching resulted in an error in table '" + tableId + "' (" + DecisionEngine.getTableInputsAsString(table, result.getContext()) + ")";
                    }
                    result.addError(new Error.ErrorBuilder(Error.Type.STAGING_ERROR).message(message).table(tableId).build());
                    continue;
                }
                if (!Endpoint.EndpointType.VALUE.equals((Object)endpoint.getType())) continue;
                List<Object> mappedKeys = new ArrayList();
                if (path.getOutputMapping() != null) {
                    for (KeyMapping keyMapping : path.getOutputMapping()) {
                        if (!keyMapping.getFrom().equals(endpoint.getResultKey())) continue;
                        mappedKeys.add(keyMapping.getTo());
                    }
                }
                if (mappedKeys.isEmpty()) {
                    mappedKeys = Collections.singletonList(endpoint.getResultKey());
                }
                for (String string : mappedKeys) {
                    if (endpoint.getValue() == null) {
                        result.getContext().remove(string);
                        continue;
                    }
                    result.getContext().put(string, DecisionEngine.translateValue(endpoint.getValue(), result.getContext()));
                }
            }
        }
        stack.pop();
        return continueProcessing;
    }

    protected static String getTableInputsAsString(Table table, Map<String, String> context) {
        ArrayList<String> inputs = new ArrayList<String>();
        if (table.getColumnDefinitions() != null) {
            for (ColumnDefinition columnDefinition : table.getColumnDefinitions()) {
                if (!ColumnDefinition.ColumnType.INPUT.equals((Object)columnDefinition.getType())) continue;
                String value = context.get(columnDefinition.getKey());
                inputs.add(value == null || value.trim().isEmpty() ? _BLANK_OUTPUT : value.trim());
            }
        }
        return Joiner.on((String)",").join(inputs);
    }
}

