/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging;

import com.imsweb.staging.StagingDataProvider;
import com.imsweb.staging.entities.Endpoint;
import com.imsweb.staging.entities.GlossaryDefinition;
import com.imsweb.staging.entities.GlossaryHit;
import com.imsweb.staging.entities.Range;
import com.imsweb.staging.entities.impl.StagingEndpoint;
import com.imsweb.staging.entities.impl.StagingRange;
import com.imsweb.staging.entities.impl.StagingSchema;
import com.imsweb.staging.entities.impl.StagingTable;
import com.imsweb.staging.entities.impl.StagingTableRow;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InMemoryDataProvider
extends StagingDataProvider {
    private final String _algorithm;
    private final String _version;
    private final Map<String, StagingTable> _tables = new HashMap<String, StagingTable>();
    private final Map<String, StagingSchema> _schemas = new HashMap<String, StagingSchema>();
    private static final String _UNSUPPORTED_MESSAGE = "Glossary not supported in this provider";

    public InMemoryDataProvider(String algorithm, String version) {
        this._algorithm = algorithm;
        this._version = version;
    }

    @Override
    public String getAlgorithm() {
        return this._algorithm;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public StagingTable getTable(String id) {
        return this._tables.get(id);
    }

    @Override
    public StagingEndpoint getEndpoint(Endpoint.EndpointType type, String value) {
        return new StagingEndpoint(type, value);
    }

    @Override
    public StagingTableRow getTableRow() {
        return new StagingTableRow();
    }

    @Override
    public Range getMatchAllRange() {
        return new StagingRange();
    }

    @Override
    public Range getRange(String low, String high) {
        return new StagingRange(low, high);
    }

    public void addTable(StagingTable table) {
        this.initTable(table);
        this._tables.put(table.getId(), table);
    }

    @Override
    public Set<String> getTableIds() {
        return this._tables.keySet();
    }

    @Override
    public StagingSchema getSchema(String id) {
        return this._schemas.get(id);
    }

    @Override
    public Set<String> getSchemaIds() {
        return this._schemas.keySet();
    }

    public void addSchema(StagingSchema schema) {
        this.initSchema(schema);
        this._schemas.put(schema.getId(), schema);
    }

    @Override
    public Set<String> getGlossaryTerms() {
        throw new IllegalStateException(_UNSUPPORTED_MESSAGE);
    }

    @Override
    public GlossaryDefinition getGlossaryDefinition(String term) {
        throw new IllegalStateException(_UNSUPPORTED_MESSAGE);
    }

    @Override
    public Collection<GlossaryHit> getGlossaryMatches(String text) {
        throw new IllegalStateException(_UNSUPPORTED_MESSAGE);
    }
}

