/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.entities.impl;

import com.imsweb.staging.engine.DecisionEngine;
import com.imsweb.staging.entities.Range;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;

public class StagingRange
implements Range {
    private String _low;
    private String _high;

    public StagingRange() {
    }

    public StagingRange(String low, String high) {
        if (low == null || high == null) {
            throw new IllegalStateException("Invalid range");
        }
        this._low = low;
        this._high = high;
    }

    @Override
    public String getLow() {
        return this._low;
    }

    @Override
    public String getHigh() {
        return this._high;
    }

    @Override
    public boolean matchesAll() {
        return this._low == null && this._high == null;
    }

    @Override
    public boolean contains(String value, Map<String, String> context) {
        String high;
        String low;
        if (this.matchesAll()) {
            return true;
        }
        if (value == null) {
            value = "";
        }
        if (!(low = DecisionEngine.translateValue(this._low, context)).equals(high = DecisionEngine.translateValue(this._high, context)) && NumberUtils.isParsable((String)low) && NumberUtils.isParsable((String)high)) {
            if (!NumberUtils.isParsable((String)value)) {
                return false;
            }
            Float converted = NumberUtils.createFloat((String)value);
            return converted.floatValue() >= NumberUtils.createFloat((String)low).floatValue() && converted.floatValue() <= NumberUtils.createFloat((String)high).floatValue();
        }
        if (low.length() != high.length() || low.length() != value.length()) {
            return false;
        }
        return low.compareTo(value) <= 0 && high.compareTo(value) >= 0;
    }
}

