/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.Sets;
import com.imsweb.decisionengine.Error;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonPropertyOrder(value={"result", "schema_id", "input", "output", "errors", "path"})
public class StagingData {
    public static final String PRIMARY_SITE_KEY = "site";
    public static final String HISTOLOGY_KEY = "hist";
    public static final String YEAR_DX_KEY = "year_dx";
    public static final Set<String> STANDARD_LOOKUP_KEYS = Sets.newHashSet((Object[])new String[]{"site", "hist"});
    private Result _result;
    private String _schemaId;
    private Map<String, String> _input = new HashMap<String, String>();
    private Map<String, String> _output = new HashMap<String, String>();
    private List<Error> _errors = new ArrayList<Error>();
    private List<String> _path = new ArrayList<String>();

    public StagingData() {
    }

    public StagingData(Map<String, String> input) {
        this._input = input;
    }

    public StagingData(String site, String hist) {
        this.setInput(PRIMARY_SITE_KEY, site);
        this.setInput(HISTOLOGY_KEY, hist);
    }

    @JsonProperty(value="result")
    public Result getResult() {
        return this._result;
    }

    public void setResult(Result result) {
        this._result = result;
    }

    @JsonProperty(value="schema_id")
    public String getSchemaId() {
        return this._schemaId;
    }

    public void setSchemaId(String schemaId) {
        this._schemaId = schemaId;
    }

    @JsonProperty(value="input")
    public Map<String, String> getInput() {
        return this._input;
    }

    @JsonIgnore
    public String getInput(String key) {
        return this._input.get(key);
    }

    public void setInput(String key, String value) {
        this._input.put(key, value);
    }

    @JsonProperty(value="output")
    public Map<String, String> getOutput() {
        return this._output;
    }

    @JsonIgnore
    public String getOutput(String key) {
        return this._output.get(key);
    }

    public void setOutput(Map<String, String> output) {
        this._output = output;
    }

    @JsonProperty(value="errors")
    public List<Error> getErrors() {
        return this._errors;
    }

    public void setErrors(List<Error> errors) {
        this._errors = errors;
    }

    public void addError(Error error) {
        this._errors.add(error);
    }

    @JsonProperty(value="path")
    public List<String> getPath() {
        return this._path;
    }

    public void setPath(List<String> path) {
        this._path = path;
    }

    public static enum Result {
        STAGED,
        FAILED_MISSING_SITE_OR_HISTOLOGY,
        FAILED_NO_MATCHING_SCHEMA,
        FAILED_MULITPLE_MATCHING_SCHEMAS,
        FAILED_INVALID_YEAR_DX,
        FAILED_INVALID_INPUT;

    }
}

