/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.imsweb.staging.StagingDataProvider;
import com.imsweb.staging.entities.StagingSchema;
import com.imsweb.staging.entities.StagingTable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class StagingFileDataProvider
extends StagingDataProvider {
    private String _algorithm;
    private String _version;
    private String _tableDirectory;
    private Set<String> _tableIds;
    private LoadingCache<String, StagingTable> _tableCache;
    private Map<String, StagingSchema> _schemas = new HashMap<String, StagingSchema>();

    protected StagingFileDataProvider(String algorithm, String version) {
        this._algorithm = algorithm;
        this._version = version;
        this._tableDirectory = "algorithms/" + algorithm.toLowerCase() + "/" + version + "/tables";
        try {
            this._tableIds = new HashSet<String>();
            for (String tableId : StagingFileDataProvider.readLines(this._tableDirectory + "/ids.txt")) {
                this._tableIds.add(tableId);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException reading ids: " + e.getMessage());
        }
        this._tableCache = CacheBuilder.newBuilder().maximumSize(2500L).build((CacheLoader)new CacheLoader<String, StagingTable>(){

            public StagingTable load(String id) throws Exception {
                StagingTable table = (StagingTable)StagingFileDataProvider.this.getMapper().reader().readValue(StagingFileDataProvider.this.getMapper().getFactory().createParser(StagingFileDataProvider.createReader(StagingFileDataProvider.this._tableDirectory + "/" + id + ".json")), StagingTable.class);
                if (!id.equals(table.getId())) {
                    throw new IllegalStateException("The table " + id + " has an identifier that doesn't match the name (" + table.getId() + ")");
                }
                StagingDataProvider.initTable(table);
                return table;
            }
        });
        try {
            String directory = "algorithms/" + algorithm.toLowerCase() + "/" + version + "/schemas";
            for (String file : StagingFileDataProvider.readLines(directory + "/ids.txt")) {
                if (file.isEmpty()) continue;
                StagingSchema schema = (StagingSchema)this.getMapper().reader().readValue(this.getMapper().getFactory().createParser(StagingFileDataProvider.createReader(directory + "/" + file + ".json")), StagingSchema.class);
                StagingFileDataProvider.initSchema(schema);
                this._schemas.put(schema.getId(), schema);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException reading schemas: " + e.getMessage());
        }
        this.invalidateCache();
    }

    @Override
    public String getAlgorithm() {
        return this._algorithm.toLowerCase();
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public StagingTable getTable(String id) {
        try {
            if (id == null) {
                return null;
            }
            return (StagingTable)this._tableCache.get((Object)id);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    @Override
    public Set<String> getSchemaIds() {
        return this._schemas.keySet();
    }

    @Override
    public Set<String> getTableIds() {
        return this._tableIds;
    }

    @Override
    public StagingSchema getDefinition(String id) {
        return this._schemas.get(id);
    }

    private static List<String> readLines(String location) throws IOException {
        return CharStreams.readLines((Readable)StagingFileDataProvider.createReader(location));
    }

    private static Reader createReader(String location) {
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        if (input == null) {
            throw new IllegalStateException("Internal error reading file; File could not be found: " + location);
        }
        return new InputStreamReader(input, StandardCharsets.UTF_8);
    }
}

