/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging;

import com.imsweb.staging.StagingDataProvider;
import com.imsweb.staging.entities.StagingSchema;
import com.imsweb.staging.entities.StagingTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ExternalStagingFileDataProvider
extends StagingDataProvider {
    private String _algorithm;
    private String _version;
    private Map<String, StagingTable> _tables = new HashMap<String, StagingTable>();
    private Map<String, StagingSchema> _schemas = new HashMap<String, StagingSchema>();

    public ExternalStagingFileDataProvider(InputStream is) throws IOException {
        this.init(is);
    }

    private static String extractEntry(InputStream is) throws IOException {
        return new BufferedReader(new InputStreamReader(is, "UTF-8")).lines().collect(Collectors.joining("\n"));
    }

    private void init(InputStream is) throws IOException {
        HashSet<String> algorithms = new HashSet<String>();
        HashSet<String> versions = new HashSet<String>();
        try (ZipInputStream stream = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                if (entry.isDirectory() || !entry.getName().endsWith(".json")) continue;
                if (entry.getName().startsWith("tables")) {
                    StagingTable table = (StagingTable)this.getMapper().reader().readValue(this.getMapper().getFactory().createParser(ExternalStagingFileDataProvider.extractEntry(stream)), StagingTable.class);
                    ExternalStagingFileDataProvider.initTable(table);
                    algorithms.add(table.getAlgorithm());
                    versions.add(table.getVersion());
                    this._tables.put(table.getId(), table);
                    continue;
                }
                if (!entry.getName().startsWith("schemas")) continue;
                StagingSchema schema = (StagingSchema)this.getMapper().reader().readValue(this.getMapper().getFactory().createParser(ExternalStagingFileDataProvider.extractEntry(stream)), StagingSchema.class);
                ExternalStagingFileDataProvider.initSchema(schema);
                algorithms.add(schema.getAlgorithm());
                versions.add(schema.getVersion());
                this._schemas.put(schema.getId(), schema);
            }
        }
        if (algorithms.size() != 1) {
            throw new IllegalStateException("Error initializing provider; only a single algorithm should be included in file");
        }
        if (versions.size() != 1) {
            throw new IllegalStateException("Error initializing provider; only a single version should be included in file");
        }
        this._algorithm = (String)algorithms.iterator().next();
        this._version = (String)versions.iterator().next();
        this.invalidateCache();
    }

    @Override
    public String getAlgorithm() {
        return this._algorithm.toLowerCase();
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public StagingTable getTable(String id) {
        return this._tables.get(id);
    }

    @Override
    public Set<String> getSchemaIds() {
        return this._schemas.keySet();
    }

    @Override
    public Set<String> getTableIds() {
        return this._tables.keySet();
    }

    @Override
    public StagingSchema getDefinition(String id) {
        return this._schemas.get(id);
    }
}

