/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.entities;

import com.imsweb.decisionengine.DecisionEngine;
import com.imsweb.decisionengine.StringRange;
import java.util.Map;
import org.mongodb.morphia.annotations.Embedded;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Property;

@Embedded
@Entity(noClassnameStored=true)
public class StagingStringRange
extends StringRange {
    @Property(value="low")
    private String _low;
    @Property(value="high")
    private String _high;

    public StagingStringRange() {
    }

    public StagingStringRange(String low, String high) {
        if (low == null || high == null) {
            throw new IllegalStateException("Invalid range");
        }
        this._low = low;
        this._high = high;
    }

    public String getLow() {
        return this._low;
    }

    public String getHigh() {
        return this._high;
    }

    public boolean matchesAll() {
        return this._low == null && this._high == null;
    }

    @Override
    public boolean contains(String value, Map<String, String> context) {
        if (this.matchesAll()) {
            return true;
        }
        if (value == null) {
            value = "";
        }
        String low = DecisionEngine.translateValue(this._low, context);
        String high = DecisionEngine.translateValue(this._high, context);
        if (low.length() != high.length() || low.length() != value.length()) {
            return false;
        }
        return low.compareTo(value) <= 0 && high.compareTo(value) >= 0;
    }
}

