/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.imsweb.decisionengine.Table;
import com.imsweb.staging.entities.StagingColumnDefinition;
import com.imsweb.staging.entities.StagingTableRow;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Embedded;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.Indexed;
import org.mongodb.morphia.annotations.Property;

@JsonPropertyOrder(value={"id", "algorithm", "version", "name", "title", "subtitle", "description", "notes", "footnotes", "last_modified", "definition", "extra_input", "rows"})
@Entity(value="staging_tables", noClassnameStored=true)
public class StagingTable
implements Table {
    @Id
    private ObjectId _id;
    @Indexed
    @Property(value="id")
    private String _displayId;
    @Indexed
    @Property(value="algorithm")
    private String _algorithm;
    @Indexed
    @Property(value="version")
    private String _version;
    @Property(value="name")
    private String _name;
    @Property(value="title")
    private String _title;
    @Property(value="description")
    private String _description;
    @Property(value="subtitle")
    private String _subtitle;
    @Property(value="notes")
    private String _notes;
    @Property(value="footnotes")
    private String _footnotes;
    @Property(value="modified")
    private Date _lastModified;
    @Embedded(value="definition")
    private List<StagingColumnDefinition> _definition;
    @Property(value="extra_input")
    private Set<String> _extraInput;
    @Property(value="rows")
    private List<List<String>> _rows = new ArrayList<List<String>>();
    @Embedded(value="parsed_table_rows")
    private List<StagingTableRow> _parsedTableRows = new ArrayList<StagingTableRow>();

    @JsonIgnore
    public ObjectId getInternalId() {
        return this._id;
    }

    public void setInternalId(ObjectId id) {
        this._id = id;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this._displayId;
    }

    public void setId(String id) {
        this._displayId = id;
    }

    @JsonProperty(value="algorithm")
    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this._algorithm = algorithm;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @JsonProperty(value="subtitle")
    public String getSubtitle() {
        return this._subtitle;
    }

    public void setSubtitle(String subtitle) {
        this._subtitle = subtitle;
    }

    @JsonProperty(value="notes")
    public String getNotes() {
        return this._notes;
    }

    public void setNotes(String notes) {
        this._notes = notes;
    }

    @JsonProperty(value="footnotes")
    public String getFootnotes() {
        return this._footnotes;
    }

    public void setFootnotes(String footnotes) {
        this._footnotes = footnotes;
    }

    @JsonProperty(value="last_modified")
    public Date getLastModified() {
        return this._lastModified;
    }

    public void setLastModified(Date lastModified) {
        this._lastModified = lastModified;
    }

    @JsonProperty(value="definition")
    public List<StagingColumnDefinition> getColumnDefinitions() {
        return this._definition;
    }

    public void setColumnDefinitions(List<StagingColumnDefinition> definition) {
        this._definition = definition;
    }

    @Override
    @JsonProperty(value="extra_input")
    public Set<String> getExtraInput() {
        return this._extraInput;
    }

    public void setExtraInput(Set<String> extraInput) {
        this._extraInput = extraInput;
    }

    @JsonProperty(value="rows")
    public List<List<String>> getRawRows() {
        return this._rows;
    }

    public void setRawRows(List<List<String>> rows) {
        this._rows = rows;
    }

    @JsonIgnore
    public List<StagingTableRow> getTableRows() {
        return this._parsedTableRows;
    }

    public void setTableRows(List<StagingTableRow> parsedTableRows) {
        this._parsedTableRows = parsedTableRows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StagingTable table = (StagingTable)o;
        return Objects.equals(this._displayId, table._displayId) && Objects.equals(this._algorithm, table._algorithm) && Objects.equals(this._version, table._version) && Objects.equals(this._name, table._name) && Objects.equals(this._title, table._title) && Objects.equals(this._description, table._description) && Objects.equals(this._subtitle, table._subtitle) && Objects.equals(this._notes, table._notes) && Objects.equals(this._footnotes, table._footnotes) && Objects.equals(this._definition, table._definition) && Objects.equals(this._extraInput, table._extraInput) && Objects.equals(this._rows, table._rows);
    }

    public int hashCode() {
        return Objects.hash(this._displayId, this._algorithm, this._version, this._name, this._title, this._description, this._subtitle, this._notes, this._footnotes, this._definition, this._extraInput, this._rows);
    }
}

