/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.imsweb.staging.StagingDataProvider;
import com.imsweb.staging.entities.StagingSchema;
import com.imsweb.staging.entities.StagingTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class StagingFileDataProvider
extends StagingDataProvider {
    private String _algorithm;
    private String _version;
    private String _tableDirectory;
    private Set<String> _tableIds;
    private LoadingCache<String, StagingTable> _tableCache;
    private Map<String, StagingSchema> _schemas = new HashMap<String, StagingSchema>();

    protected StagingFileDataProvider(String algorithm, String version) {
        this._algorithm = algorithm;
        this._version = version;
        this._tableDirectory = "algorithms/" + algorithm.toLowerCase() + "/" + version + "/tables";
        try {
            this._tableIds = new HashSet<String>();
            this._tableIds.addAll(StagingFileDataProvider.readLines(this._tableDirectory + "/ids.txt"));
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException reading ids: " + e.getMessage());
        }
        this._tableCache = Caffeine.newBuilder().maximumSize(2500L).build(this::load);
        try {
            String directory = "algorithms/" + algorithm.toLowerCase() + "/" + version + "/schemas";
            for (String file : StagingFileDataProvider.readLines(directory + "/ids.txt")) {
                if (file.isEmpty()) continue;
                StagingSchema schema = (StagingSchema)this.getMapper().reader().readValue(this.getMapper().getFactory().createParser(StagingFileDataProvider.getStagingInputStream(directory + "/" + file + ".json")), StagingSchema.class);
                StagingFileDataProvider.initSchema(schema);
                this._schemas.put(schema.getId(), schema);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException reading schemas: " + e.getMessage());
        }
        this.invalidateCache();
    }

    private static List<String> readLines(String location) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(StagingFileDataProvider.getStagingInputStream(location), StandardCharsets.UTF_8));){
            List<String> list = buffer.lines().collect(Collectors.toList());
            return list;
        }
    }

    private static InputStream getStagingInputStream(String location) {
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        if (input == null) {
            throw new IllegalStateException("Internal error reading file; File could not be found: " + location);
        }
        return input;
    }

    @Override
    public String getAlgorithm() {
        return this._algorithm.toLowerCase();
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public StagingTable getTable(String id) {
        if (id == null) {
            return null;
        }
        return (StagingTable)this._tableCache.get((Object)id);
    }

    @Override
    public Set<String> getSchemaIds() {
        return this._schemas.keySet();
    }

    @Override
    public Set<String> getTableIds() {
        return this._tableIds;
    }

    @Override
    public StagingSchema getDefinition(String id) {
        return this._schemas.get(id);
    }

    private StagingTable load(String id) throws Exception {
        StagingTable table = (StagingTable)this.getMapper().reader().readValue(this.getMapper().getFactory().createParser(StagingFileDataProvider.getStagingInputStream(this._tableDirectory + "/" + id + ".json")), StagingTable.class);
        if (!id.equals(table.getId())) {
            throw new IllegalStateException("The table " + id + " has an identifier that doesn't match the name (" + table.getId() + ")");
        }
        StagingFileDataProvider.initTable(table);
        return table;
    }
}

