/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.tnm;

import com.imsweb.staging.StagingFileDataProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TnmDataProvider
extends StagingFileDataProvider {
    private static final Map<TnmVersion, TnmDataProvider> _PROVIDERS = new ConcurrentHashMap<TnmVersion, TnmDataProvider>();

    private TnmDataProvider(TnmVersion version) {
        super("tnm", version.getVersion());
    }

    public static synchronized TnmDataProvider getInstance() {
        return TnmDataProvider.getInstance(TnmVersion.LATEST);
    }

    public static synchronized TnmDataProvider getInstance(TnmVersion version) {
        TnmDataProvider provider = _PROVIDERS.get((Object)version);
        if (provider == null) {
            provider = new TnmDataProvider(version);
            _PROVIDERS.put(version, provider);
        }
        return provider;
    }

    public static enum TnmVersion {
        LATEST("1.4"),
        v1_4("1.4");

        private String _version;

        private TnmVersion(String version) {
            this._version = version;
        }

        public String getVersion() {
            return this._version;
        }
    }
}

