/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.eod;

import com.imsweb.staging.StagingFileDataProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class EodDataProvider
extends StagingFileDataProvider {
    private static final Map<EodVersion, EodDataProvider> _PROVIDERS = new ConcurrentHashMap<EodVersion, EodDataProvider>();

    private EodDataProvider(EodVersion version) {
        super("eod_public", version.getVersion());
    }

    public static synchronized EodDataProvider getInstance() {
        return EodDataProvider.getInstance(EodVersion.LATEST);
    }

    public static synchronized EodDataProvider getInstance(EodVersion version) {
        EodDataProvider provider = _PROVIDERS.get((Object)version);
        if (provider == null) {
            provider = new EodDataProvider(version);
            _PROVIDERS.put(version, provider);
        }
        return provider;
    }

    public static enum EodVersion {
        LATEST("1.1"),
        v1_1("1.1");

        private String _version;

        private EodVersion(String version) {
            this._version = version;
        }

        public String getVersion() {
            return this._version;
        }
    }
}

