/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging;

import com.imsweb.staging.StagingDataProvider;
import com.imsweb.staging.entities.GlossaryDefinition;
import com.imsweb.staging.entities.StagingSchema;
import com.imsweb.staging.entities.StagingTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ahocorasick.trie.Trie;

public class StagingFileDataProvider
extends StagingDataProvider {
    private final String _algorithm;
    private final String _version;
    private final Map<String, StagingTable> _tables;
    private final Map<String, StagingSchema> _schemas;
    private final Map<String, String> _glossaryTerms;

    protected StagingFileDataProvider(String algorithm, String version) {
        block22: {
            String directory;
            this._tables = new HashMap<String, StagingTable>();
            this._schemas = new HashMap<String, StagingSchema>();
            this._glossaryTerms = new HashMap<String, String>();
            this._algorithm = algorithm;
            this._version = version;
            try {
                directory = "algorithms/" + algorithm.toLowerCase() + "/" + version + "/tables";
                for (String file : StagingFileDataProvider.readLines(directory + "/ids.txt")) {
                    if (file.isEmpty()) continue;
                    StagingTable table = (StagingTable)this.getMapper().reader().readValue(this.getMapper().getFactory().createParser(StagingFileDataProvider.getStagingInputStream(directory + "/" + file + ".json")), StagingTable.class);
                    StagingFileDataProvider.initTable(table);
                    this._tables.put(table.getId(), table);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException reading schemas: " + e.getMessage());
            }
            try {
                directory = "algorithms/" + algorithm.toLowerCase() + "/" + version + "/schemas";
                for (String file : StagingFileDataProvider.readLines(directory + "/ids.txt")) {
                    if (file.isEmpty()) continue;
                    StagingSchema schema = (StagingSchema)this.getMapper().reader().readValue(this.getMapper().getFactory().createParser(StagingFileDataProvider.getStagingInputStream(directory + "/" + file + ".json")), StagingSchema.class);
                    StagingFileDataProvider.initSchema(schema);
                    this._schemas.put(schema.getId(), schema);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException reading schemas: " + e.getMessage());
            }
            try {
                String keywords = "algorithms/" + algorithm.toLowerCase() + "/" + version + "/glossary/terms.txt";
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(keywords);
                if (is == null) break block22;
                Trie.TrieBuilder builder = Trie.builder().onlyWholeWords().ignoreCase();
                try (BufferedReader buffer = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                    for (String line : buffer.lines().collect(Collectors.toList())) {
                        if (line.length() <= 0) continue;
                        String[] parts = line.split("~");
                        if (parts.length != 2) {
                            throw new IllegalStateException("Error parsing glossary terms.  Should only be two parts of each line in terms.txt");
                        }
                        this._glossaryTerms.put(parts[0], parts[1]);
                        builder.addKeyword(parts[0]);
                    }
                }
                this._trie = builder.build();
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException reading glossary terms: " + e.getMessage());
            }
        }
        this.invalidateCache();
    }

    private static List<String> readLines(String location) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(StagingFileDataProvider.getStagingInputStream(location), StandardCharsets.UTF_8));){
            List<String> list = buffer.lines().collect(Collectors.toList());
            return list;
        }
    }

    private static InputStream getStagingInputStream(String location) {
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        if (input == null) {
            throw new IllegalStateException("Internal error reading file; File could not be found: " + location);
        }
        return input;
    }

    @Override
    public String getAlgorithm() {
        return this._algorithm.toLowerCase();
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public StagingTable getTable(String id) {
        return this._tables.get(id);
    }

    @Override
    public Set<String> getSchemaIds() {
        return this._schemas.keySet();
    }

    @Override
    public Set<String> getTableIds() {
        return this._tables.keySet();
    }

    @Override
    public StagingSchema getDefinition(String id) {
        return this._schemas.get(id);
    }

    @Override
    public Set<String> getGlossaryTerms() {
        return this._glossaryTerms.keySet();
    }

    @Override
    public GlossaryDefinition getGlossaryDefinition(String term) {
        String id = this._glossaryTerms.get(term);
        if (id == null) {
            return null;
        }
        String filename = "algorithms/" + this.getAlgorithm() + "/" + this.getVersion() + "/glossary/" + id + ".json";
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        if (input == null) {
            return null;
        }
        try {
            return (GlossaryDefinition)this.getMapper().reader().readValue(this.getMapper().getFactory().createParser(input), GlossaryDefinition.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading glossary term: " + e.getMessage());
        }
    }
}

