/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.imsweb.staging.Staging;
import com.imsweb.staging.engine.DecisionEngine;
import com.imsweb.staging.entities.ColumnDefinition;
import com.imsweb.staging.entities.DataProvider;
import com.imsweb.staging.entities.Endpoint;
import com.imsweb.staging.entities.GlossaryDefinition;
import com.imsweb.staging.entities.GlossaryHit;
import com.imsweb.staging.entities.Input;
import com.imsweb.staging.entities.KeyValue;
import com.imsweb.staging.entities.Mapping;
import com.imsweb.staging.entities.Output;
import com.imsweb.staging.entities.Range;
import com.imsweb.staging.entities.Schema;
import com.imsweb.staging.entities.SchemaLookup;
import com.imsweb.staging.entities.Table;
import com.imsweb.staging.entities.TableRow;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.ahocorasick.trie.Trie;
import org.apache.commons.lang3.math.NumberUtils;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;

public abstract class StagingDataProvider
implements DataProvider {
    public static final String PRIMARY_SITE_TABLE = "primary_site";
    public static final String HISTOLOGY_TABLE = "histology";
    private final ObjectMapper _mapper = new ObjectMapper();
    private final Range _matchAllEndpoint = this.getMatchAllRange();
    protected Trie _trie;
    private final Cache<SchemaLookup, List<Schema>> _lookupCache;
    private final Cache<String, Set<String>> _validValuesCache;

    protected StagingDataProvider() {
        this._mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        this._mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this._mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this._mapper.setDateFormat((DateFormat)dateFormat);
        this._mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        this._mapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.ANY);
        this._lookupCache = new Cache2kBuilder<SchemaLookup, List<Schema>>(){}.entryCapacity(500L).eternal(true).loader(this::getSchemas).build();
        this._validValuesCache = new Cache2kBuilder<String, Set<String>>(){}.eternal(true).loader(this::getAllInputValues).build();
    }

    public Schema initSchema(Schema schema) {
        if (schema.getSchemaSelectionTable() == null) {
            throw new IllegalStateException("Schemas must have a schema selection table.");
        }
        if (schema.getInputs() != null) {
            HashMap<String, Input> parsedInputMap = new HashMap<String, Input>();
            for (Input input : schema.getInputs()) {
                if (input.getKey() == null) {
                    throw new IllegalStateException("All input definitions must have a 'key' defined.");
                }
                parsedInputMap.put(input.getKey(), input);
            }
            schema.setInputMap(parsedInputMap);
        }
        if (schema.getOutputs() != null) {
            HashMap<String, Output> parsedOutputMap = new HashMap<String, Output>();
            for (Output output : schema.getOutputs()) {
                if (output.getKey() == null) {
                    throw new IllegalStateException("All output definitions must have a 'key' defined.");
                }
                parsedOutputMap.put(output.getKey(), output);
            }
            schema.setOutputMap(parsedOutputMap);
        }
        if (schema.getMappings() != null) {
            for (Mapping mapping : schema.getMappings()) {
                if (mapping.getInitialContext() == null) continue;
                for (KeyValue keyValue : mapping.getInitialContext()) {
                    if (!schema.getInputMap().containsKey(keyValue.getKey())) continue;
                    throw new IllegalStateException("The key '" + keyValue.getKey() + "' is defined in an initial context, but that is not allowed since it is also defined as an input.");
                }
            }
        }
        return schema;
    }

    public Table initTable(Table table) {
        HashSet<String> extraInputs = new HashSet<String>();
        table.clearTableRows();
        if (table.getRawRows() != null) {
            for (List<String> row : table.getRawRows()) {
                TableRow tableRowEntity = this.getTableRow();
                if (table.getColumnDefinitions().size() != row.size()) {
                    throw new IllegalStateException("Table '" + table.getId() + "' has a row with " + row.size() + " values but should have " + table.getColumnDefinitions().size() + ": " + row);
                }
                block6: for (int i = 0; i < table.getColumnDefinitions().size(); ++i) {
                    ColumnDefinition col = table.getColumnDefinitions().get(i);
                    String cellValue = row.get(i);
                    switch (col.getType()) {
                        case INPUT: {
                            List<? extends Range> ranges = this.splitValues(cellValue);
                            if (ranges.isEmpty()) continue block6;
                            tableRowEntity.addInput(col.getKey(), ranges);
                            for (Range range : ranges) {
                                if (DecisionEngine.isReferenceVariable(range.getLow())) {
                                    extraInputs.add(DecisionEngine.trimBraces(range.getLow()));
                                }
                                if (!DecisionEngine.isReferenceVariable(range.getHigh())) continue;
                                extraInputs.add(DecisionEngine.trimBraces(range.getHigh()));
                            }
                            continue block6;
                        }
                        case ENDPOINT: {
                            Endpoint endpoint = this.parseEndpoint(cellValue);
                            endpoint.setResultKey(col.getKey());
                            tableRowEntity.addEndpoint(endpoint);
                            if (!Endpoint.EndpointType.VALUE.equals((Object)endpoint.getType()) || !DecisionEngine.isReferenceVariable(endpoint.getValue())) continue block6;
                            extraInputs.add(DecisionEngine.trimBraces(endpoint.getValue()));
                            continue block6;
                        }
                        case DESCRIPTION: {
                            continue block6;
                        }
                        default: {
                            throw new IllegalStateException("Table '" + table.getId() + " has an unknown column type: '" + (Object)((Object)col.getType()) + "'");
                        }
                    }
                }
                table.addTableRow(tableRowEntity);
            }
        }
        Staging.CONTEXT_KEYS.forEach(extraInputs::remove);
        table.setExtraInput(extraInputs.isEmpty() ? null : extraInputs);
        return table;
    }

    public Endpoint parseEndpoint(String endpoint) {
        String value;
        String[] parts = endpoint.split(":", 2);
        Endpoint.EndpointType type = null;
        try {
            type = Endpoint.EndpointType.valueOf(parts[0].trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (type == null) {
            throw new IllegalStateException("Invalid endpoint type: '" + endpoint + "'.  Must be either JUMP, VALUE, MATCH, STOP, or ERROR");
        }
        String string = value = parts.length == 2 ? parts[1].trim() : null;
        if ((value == null || value.isEmpty()) && Endpoint.EndpointType.JUMP.equals((Object)type)) {
            throw new IllegalStateException("JUMP endpoint types must have a value: '" + endpoint + "'");
        }
        return this.getEndpoint(type, value);
    }

    public List<? extends Range> splitValues(String values) {
        ArrayList<Range> convertedRanges = new ArrayList<Range>();
        if (values != null) {
            if (values.equals("*")) {
                convertedRanges.add(this._matchAllEndpoint);
            } else {
                String[] ranges;
                for (String range : ranges = values.split(",", -1)) {
                    String[] parts = range.split("-");
                    if (parts.length == 2) {
                        boolean isNumericRange;
                        String low = parts[0].trim();
                        String high = parts[1].trim();
                        boolean bl = isNumericRange = StagingDataProvider.isNumeric(low) && StagingDataProvider.isNumeric(high);
                        if (low.length() == high.length() || isNumericRange || DecisionEngine.isReferenceVariable(low) || DecisionEngine.isReferenceVariable(high)) {
                            convertedRanges.add(this.getRange(low, high));
                            continue;
                        }
                        convertedRanges.add(this.getRange(range.trim(), range.trim()));
                        continue;
                    }
                    convertedRanges.add(this.getRange(range.trim(), range.trim()));
                }
            }
        }
        return convertedRanges;
    }

    public static boolean isNumeric(String value) {
        return NumberUtils.isParsable((String)value);
    }

    static String padStart(String string, int minLength, char padChar) {
        if (string == null || string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(string);
        return sb.toString();
    }

    public void invalidateCache() {
        this._lookupCache.removeAll();
        this._validValuesCache.removeAll();
    }

    public boolean isValidSite(String site) {
        boolean valid;
        boolean bl = valid = site != null;
        if (valid) {
            Table table = this.getTable(PRIMARY_SITE_TABLE);
            if (table == null) {
                throw new IllegalStateException("Unable to locate primary_site table");
            }
            valid = this.getValidSites().contains(site);
        }
        return valid;
    }

    public boolean isValidHistology(String histology) {
        boolean valid;
        boolean bl = valid = histology != null;
        if (valid) {
            Table table = this.getTable(HISTOLOGY_TABLE);
            if (table == null) {
                throw new IllegalStateException("Unable to locate histology table");
            }
            valid = this.getValidHistologies().contains(histology);
        }
        return valid;
    }

    public ObjectMapper getMapper() {
        return this._mapper;
    }

    public abstract String getAlgorithm();

    public abstract String getVersion();

    public abstract Endpoint getEndpoint(Endpoint.EndpointType var1, String var2);

    public abstract TableRow getTableRow();

    public abstract Range getMatchAllRange();

    public abstract Range getRange(String var1, String var2);

    public abstract Set<String> getSchemaIds();

    public abstract Set<String> getTableIds();

    public abstract Set<String> getGlossaryTerms();

    public abstract GlossaryDefinition getGlossaryDefinition(String var1);

    public Collection<GlossaryHit> getGlossaryMatches(String text) {
        return this._trie.parseText((CharSequence)text).stream().map(hit -> new GlossaryHit(hit.getKeyword(), hit.getStart(), hit.getEnd())).collect(Collectors.toSet());
    }

    public Set<String> getValidSites() {
        return (Set)this._validValuesCache.get((Object)PRIMARY_SITE_TABLE);
    }

    public Set<String> getValidHistologies() {
        return (Set)this._validValuesCache.get((Object)HISTOLOGY_TABLE);
    }

    public List<Schema> lookupSchema(SchemaLookup lookup) {
        if (lookup.getSite() == null || lookup.getHistology() == null) {
            return this.getSchemas(lookup);
        }
        return (List)this._lookupCache.get((Object)lookup);
    }

    private List<Schema> getSchemas(SchemaLookup lookup) {
        ArrayList<Schema> matchedSchemas = new ArrayList<Schema>();
        String site = lookup.getInput("site");
        String histology = lookup.getInput("hist");
        boolean hasDiscriminator = lookup.hasDiscriminator();
        if (site != null && !this.isValidSite(site) || histology != null && !this.isValidHistology(histology)) {
            return matchedSchemas;
        }
        if (hasDiscriminator && (site == null || site.isEmpty() || histology == null || histology.isEmpty())) {
            return matchedSchemas;
        }
        if (site != null || histology != null) {
            for (String schemaId : this.getSchemaIds()) {
                Table table;
                Schema schema = this.getSchema(schemaId);
                if (schema.getSchemaSelectionTable() == null || (table = this.getTable(schema.getSchemaSelectionTable())) == null || DecisionEngine.matchTable(table, lookup.getInputs(), lookup.getKeys()) == null) continue;
                matchedSchemas.add(schema);
            }
        }
        return matchedSchemas;
    }

    private Set<String> getAllInputValues(String tableId) {
        HashSet<String> values = new HashSet<String>();
        Table table = this.getTable(tableId);
        if (table == null) {
            return values;
        }
        Set inputKeys = table.getColumnDefinitions().stream().filter(def -> ColumnDefinition.ColumnType.INPUT.equals((Object)def.getType())).map(ColumnDefinition::getKey).collect(Collectors.toSet());
        if (inputKeys.size() != 1) {
            throw new IllegalStateException("Table '" + table.getId() + "' must have one and only one INPUT column.");
        }
        String inputKey = (String)inputKeys.iterator().next();
        for (TableRow tableRow : table.getTableRows()) {
            for (Range range : tableRow.getColumnInput(inputKey)) {
                if (range.getLow() == null) continue;
                if (range.getLow().equals(range.getHigh())) {
                    values.add(range.getLow());
                    continue;
                }
                int low = Integer.parseInt(range.getLow());
                int high = Integer.parseInt(range.getHigh());
                for (int i = low; i <= high; ++i) {
                    values.add(StagingDataProvider.padStart(String.valueOf(i), range.getLow().length(), '0'));
                }
            }
        }
        return values;
    }
}

