/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.entities.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.imsweb.staging.entities.Input;
import com.imsweb.staging.entities.Output;
import com.imsweb.staging.entities.Schema;
import com.imsweb.staging.entities.impl.StagingKeyValue;
import com.imsweb.staging.entities.impl.StagingMapping;
import com.imsweb.staging.entities.impl.StagingSchemaInput;
import com.imsweb.staging.entities.impl.StagingSchemaOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonPropertyOrder(value={"id", "algorithm", "version", "name", "title", "subtitle", "description", "notes", "schema_num", "schema_selection_table", "schema_discriminators", "initial_context", "inputs", "outputs", "mappings", "involved_tables", "on_invalid_input", "last_modified"})
public class StagingSchema
implements Schema {
    private String _displayId;
    private String _algorithm;
    private String _version;
    private String _name;
    private String _title;
    private String _description;
    private String _subtitle;
    private String _notes;
    private Date _lastModified;
    private Integer _schemaNum;
    private String _schemaSelectionTable;
    private Set<String> _schemaDiscriminators;
    private List<StagingSchemaInput> _inputs;
    private List<StagingSchemaOutput> _outputs;
    private Set<StagingKeyValue> _initialContext;
    private List<StagingMapping> _mappings;
    private Set<String> _involvedTables;
    private Schema.StagingInputErrorHandler _onInvalidInput;
    private Map<String, StagingSchemaInput> _parsedInputMap = new HashMap<String, StagingSchemaInput>();
    private Map<String, StagingSchemaOutput> _parsedOutputMap = new HashMap<String, StagingSchemaOutput>();

    public StagingSchema() {
    }

    public StagingSchema(String id) {
        this.setId(id);
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this._displayId;
    }

    public void setId(String id) {
        this._displayId = id;
    }

    @Override
    @JsonProperty(value="algorithm")
    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this._algorithm = algorithm;
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    @JsonProperty(value="title")
    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    @JsonProperty(value="subtitle")
    public String getSubtitle() {
        return this._subtitle;
    }

    public void setSubtitle(String subtitle) {
        this._subtitle = subtitle;
    }

    @Override
    @JsonProperty(value="notes")
    public String getNotes() {
        return this._notes;
    }

    public void setNotes(String notes) {
        this._notes = notes;
    }

    @Override
    @JsonProperty(value="last_modified")
    public Date getLastModified() {
        return this._lastModified;
    }

    public void setLastModified(Date lastModified) {
        this._lastModified = lastModified;
    }

    @Override
    @JsonProperty(value="schema_num")
    public Integer getSchemaNum() {
        return this._schemaNum;
    }

    public void setSchemaNum(Integer schemaNum) {
        this._schemaNum = schemaNum;
    }

    @Override
    @JsonProperty(value="schema_selection_table")
    public String getSchemaSelectionTable() {
        return this._schemaSelectionTable;
    }

    public void setSchemaSelectionTable(String schemaSelectionTable) {
        this._schemaSelectionTable = schemaSelectionTable;
    }

    @Override
    @JsonProperty(value="schema_discriminators")
    public Set<String> getSchemaDiscriminators() {
        return this._schemaDiscriminators;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setSchemaDiscriminators(Set<String> schemaDiscriminators) {
        this._schemaDiscriminators = schemaDiscriminators;
    }

    @JsonProperty(value="inputs")
    public List<StagingSchemaInput> getInputs() {
        return this._inputs;
    }

    public void setInputs(List<StagingSchemaInput> inputs) {
        this._inputs = inputs;
    }

    public void addInput(String key) {
        if (this._inputs == null) {
            this._inputs = new ArrayList<StagingSchemaInput>();
        }
        this._inputs.add(new StagingSchemaInput(key));
    }

    public void addInput(StagingSchemaInput input) {
        if (this._inputs == null) {
            this._inputs = new ArrayList<StagingSchemaInput>();
        }
        this._inputs.add(input);
    }

    @JsonProperty(value="outputs")
    public List<StagingSchemaOutput> getOutputs() {
        return this._outputs;
    }

    public void setOutputs(List<StagingSchemaOutput> outputs) {
        this._outputs = outputs;
    }

    public void addOutput(StagingSchemaOutput output) {
        if (this._outputs == null) {
            this._outputs = new ArrayList<StagingSchemaOutput>();
        }
        this._outputs.add(output);
    }

    @JsonProperty(value="initial_context")
    public Set<StagingKeyValue> getInitialContext() {
        return this._initialContext;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setInitialContext(Set<StagingKeyValue> initialContext) {
        this._initialContext = initialContext;
    }

    public void addInitialContext(String key, String value) {
        if (this._initialContext == null) {
            this._initialContext = new HashSet<StagingKeyValue>();
        }
        this._initialContext.add(new StagingKeyValue(key, value));
    }

    @JsonProperty(value="mappings")
    public List<StagingMapping> getMappings() {
        return this._mappings;
    }

    public void setMappings(List<StagingMapping> mapping) {
        this._mappings = mapping;
    }

    public void addMapping(StagingMapping mapping) {
        if (this._mappings == null) {
            this._mappings = new ArrayList<StagingMapping>();
        }
        this._mappings.add(mapping);
    }

    @JsonIgnore
    public Map<String, StagingSchemaInput> getInputMap() {
        return this._parsedInputMap;
    }

    @Override
    public void setInputMap(Map<String, ? extends Input> parsedInputMap) {
        this._parsedInputMap = parsedInputMap;
    }

    @JsonIgnore
    public Map<String, StagingSchemaOutput> getOutputMap() {
        return this._parsedOutputMap;
    }

    @Override
    public void setOutputMap(Map<String, ? extends Output> parsedOutputMap) {
        this._parsedOutputMap = parsedOutputMap;
    }

    @Override
    @JsonProperty(value="involved_tables")
    public Set<String> getInvolvedTables() {
        return this._involvedTables;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setInvolvedTables(Set<String> involvedTables) {
        this._involvedTables = involvedTables;
    }

    @Override
    @JsonProperty(value="on_invalid_input")
    public Schema.StagingInputErrorHandler getOnInvalidInput() {
        return this._onInvalidInput;
    }

    public void setOnInvalidInput(Schema.StagingInputErrorHandler onInvalidInput) {
        this._onInvalidInput = onInvalidInput;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StagingSchema schema = (StagingSchema)o;
        return Objects.equals(this._displayId, schema._displayId) && Objects.equals(this._algorithm, schema._algorithm) && Objects.equals(this._version, schema._version) && Objects.equals(this._name, schema._name) && Objects.equals(this._title, schema._title) && Objects.equals(this._description, schema._description) && Objects.equals(this._subtitle, schema._subtitle) && Objects.equals(this._notes, schema._notes) && Objects.equals(this._schemaNum, schema._schemaNum) && Objects.equals(this._schemaSelectionTable, schema._schemaSelectionTable) && Objects.equals(this._schemaDiscriminators, schema._schemaDiscriminators) && Objects.equals(this._inputs, schema._inputs) && Objects.equals(this._outputs, schema._outputs) && Objects.equals(this._initialContext, schema._initialContext) && Objects.equals(this._mappings, schema._mappings) && Objects.equals((Object)this._onInvalidInput, (Object)schema._onInvalidInput) && Objects.equals(this._involvedTables, schema._involvedTables);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._displayId, this._algorithm, this._version, this._name, this._title, this._description, this._subtitle, this._notes, this._schemaNum, this._schemaSelectionTable, this._schemaDiscriminators, this._inputs, this._outputs, this._initialContext, this._mappings, this._onInvalidInput, this._involvedTables});
    }
}

