/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.entities.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.imsweb.staging.entities.ColumnDefinition;
import com.imsweb.staging.entities.Table;
import com.imsweb.staging.entities.TableRow;
import com.imsweb.staging.entities.impl.StagingColumnDefinition;
import com.imsweb.staging.entities.impl.StagingTableRow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonPropertyOrder(value={"id", "algorithm", "version", "name", "title", "subtitle", "description", "notes", "footnotes", "last_modified", "definition", "extra_input", "rows"})
public class StagingTable
implements Table {
    private String _displayId;
    private String _algorithm;
    private String _version;
    private String _name;
    private String _title;
    private String _description;
    private String _subtitle;
    private String _notes;
    private String _footnotes;
    private Date _lastModified;
    private List<StagingColumnDefinition> _definition;
    private Set<String> _extraInput;
    private List<List<String>> _rows = new ArrayList<List<String>>();
    private List<StagingTableRow> _parsedTableRows = new ArrayList<StagingTableRow>();

    public StagingTable() {
    }

    public StagingTable(String id) {
        this.setId(id);
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this._displayId;
    }

    public void setId(String id) {
        this._displayId = id;
    }

    @Override
    @JsonProperty(value="algorithm")
    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this._algorithm = algorithm;
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    @JsonProperty(value="title")
    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    @JsonProperty(value="subtitle")
    public String getSubtitle() {
        return this._subtitle;
    }

    public void setSubtitle(String subtitle) {
        this._subtitle = subtitle;
    }

    @Override
    @JsonProperty(value="notes")
    public String getNotes() {
        return this._notes;
    }

    public void setNotes(String notes) {
        this._notes = notes;
    }

    @Override
    @JsonProperty(value="footnotes")
    public String getFootnotes() {
        return this._footnotes;
    }

    public void setFootnotes(String footnotes) {
        this._footnotes = footnotes;
    }

    @Override
    @JsonProperty(value="last_modified")
    public Date getLastModified() {
        return this._lastModified;
    }

    public void setLastModified(Date lastModified) {
        this._lastModified = lastModified;
    }

    @JsonProperty(value="definition")
    public List<StagingColumnDefinition> getColumnDefinitions() {
        return this._definition;
    }

    public void setColumnDefinitions(List<StagingColumnDefinition> definition) {
        this._definition = definition;
    }

    public void addColumnDefinition(String key, ColumnDefinition.ColumnType type) {
        if (this._definition == null) {
            this._definition = new ArrayList<StagingColumnDefinition>();
        }
        StagingColumnDefinition def = new StagingColumnDefinition();
        def.setKey(key);
        def.setType(type);
        this._definition.add(def);
    }

    @Override
    @JsonProperty(value="extra_input")
    public Set<String> getExtraInput() {
        return this._extraInput;
    }

    @Override
    public void setExtraInput(Set<String> extraInput) {
        this._extraInput = extraInput;
    }

    @Override
    @JsonProperty(value="rows")
    public List<List<String>> getRawRows() {
        return this._rows;
    }

    public void setRawRows(List<List<String>> rows) {
        this._rows = rows;
    }

    public void addRawRow(String ... row) {
        if (this._rows == null) {
            this._rows = new ArrayList<List<String>>();
        }
        this._rows.add(Arrays.asList(row));
    }

    @JsonIgnore
    public List<StagingTableRow> getTableRows() {
        return this._parsedTableRows;
    }

    public void setTableRows(List<StagingTableRow> parsedTableRows) {
        this._parsedTableRows = parsedTableRows;
    }

    @Override
    public void addTableRow(TableRow row) {
        this.getTableRows().add((StagingTableRow)row);
    }

    @Override
    public void clearTableRows() {
        this._parsedTableRows.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StagingTable table = (StagingTable)o;
        return Objects.equals(this._displayId, table._displayId) && Objects.equals(this._algorithm, table._algorithm) && Objects.equals(this._version, table._version) && Objects.equals(this._name, table._name) && Objects.equals(this._title, table._title) && Objects.equals(this._description, table._description) && Objects.equals(this._subtitle, table._subtitle) && Objects.equals(this._notes, table._notes) && Objects.equals(this._footnotes, table._footnotes) && Objects.equals(this._definition, table._definition) && Objects.equals(this._extraInput, table._extraInput) && Objects.equals(this._rows, table._rows);
    }

    public int hashCode() {
        return Objects.hash(this._displayId, this._algorithm, this._version, this._name, this._title, this._description, this._subtitle, this._notes, this._footnotes, this._definition, this._extraInput, this._rows);
    }
}

