/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.entities.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.imsweb.staging.entities.TablePath;
import com.imsweb.staging.entities.impl.StagingKeyMapping;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

@JsonPropertyOrder(value={"id", "input_mapping", "output_mapping", "inputs", "outputs"})
public class StagingTablePath
implements TablePath {
    private String _id;
    private Set<StagingKeyMapping> _inputMapping;
    private Set<StagingKeyMapping> _outputMapping;
    private Set<String> _inputs;
    private Set<String> _outputs;

    public StagingTablePath() {
    }

    public StagingTablePath(String id) {
        this.setId(id);
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    @JsonProperty(value="input_mapping")
    public Set<StagingKeyMapping> getInputMapping() {
        return this._inputMapping;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setInputMapping(Set<StagingKeyMapping> input) {
        this._inputMapping = input;
    }

    public void addInputMapping(String from, String to) {
        if (this._inputMapping == null) {
            this._inputMapping = new HashSet<StagingKeyMapping>();
        }
        this._inputMapping.add(new StagingKeyMapping(from, to));
    }

    @JsonProperty(value="output_mapping")
    public Set<StagingKeyMapping> getOutputMapping() {
        return this._outputMapping;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setOutputMapping(Set<StagingKeyMapping> output) {
        this._outputMapping = output;
    }

    public void addOutputMapping(String from, String to) {
        if (this._outputMapping == null) {
            this._outputMapping = new HashSet<StagingKeyMapping>();
        }
        this._outputMapping.add(new StagingKeyMapping(from, to));
    }

    @Override
    @JsonProperty(value="inputs")
    public Set<String> getInputs() {
        return this._inputs;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setInputs(Set<String> inputs) {
        this._inputs = inputs;
    }

    @Override
    @JsonProperty(value="outputs")
    public Set<String> getOutputs() {
        return this._outputs;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setOutputs(Set<String> outputs) {
        this._outputs = outputs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StagingTablePath that = (StagingTablePath)o;
        return Objects.equals(this._id, that._id) && Objects.equals(this._inputMapping, that._inputMapping) && Objects.equals(this._inputs, that._inputs) && Objects.equals(this._outputMapping, that._outputMapping) && Objects.equals(this._outputs, that._outputs);
    }

    public int hashCode() {
        return Objects.hash(this._id, this._inputMapping, this._inputs, this._outputMapping, this._outputs);
    }
}

