/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.update;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.imsweb.seerapi.client.SeerApi;
import com.imsweb.seerapi.client.glossary.Glossary;
import com.imsweb.seerapi.client.glossary.GlossaryService;
import com.imsweb.seerapi.client.staging.StagingSchema;
import com.imsweb.seerapi.client.staging.StagingSchemaInfo;
import com.imsweb.seerapi.client.staging.StagingService;
import com.imsweb.seerapi.client.staging.StagingTable;
import com.imsweb.staging.entities.GlossaryDefinition;
import com.imsweb.staging.util.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpdaterUtils {
    private static final Logger _LOG = LoggerFactory.getLogger(UpdaterUtils.class);
    private static final Pattern _ID_CHARACTERS = Pattern.compile("[a-z0-9_]+");

    private UpdaterUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void update(String algorithm, String version, String baseDirectory, Set<String> glossaryCategories) throws IOException {
        Set matches;
        Stopwatch stopwatch = Stopwatch.create();
        Set categories = glossaryCategories.stream().map(Glossary.Category::valueOf).collect(Collectors.toSet());
        _LOG.info("Updating {} version {} from SEER*API", (Object)algorithm, (Object)version);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.ALWAYS, (JsonInclude.Include)JsonInclude.Include.NON_NULL));
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        mapper.setDateFormat((DateFormat)format);
        StagingService staging = new SeerApi.Builder().connect().staging();
        _LOG.info("Getting list of unused table identifiers");
        HashSet<String> unusedTableIds = new HashSet<String>();
        for (Object table : (List)staging.tables(algorithm, version, null, Boolean.valueOf(true)).execute().body()) {
            unusedTableIds.add(table.getId());
        }
        _LOG.info("{} unused table identifiers found.", (Object)unusedTableIds.size());
        _LOG.info("Getting list of table identifiers");
        ArrayList<String> tableIds = new ArrayList<String>();
        for (Object table : (List)staging.tables(algorithm, version, null).execute().body()) {
            String id = table.getId();
            if (!_ID_CHARACTERS.matcher(id).matches()) {
                _LOG.info(" **** skipping bad table identifier: '{}' ****", (Object)id);
                continue;
            }
            if (unusedTableIds.contains(id)) {
                _LOG.info(" **** skipping unused table identifier: '{}' ****", (Object)id);
                continue;
            }
            tableIds.add(id);
        }
        _LOG.info("{} valid table identifiers found.", (Object)tableIds.size());
        _LOG.info("Getting list of schema identifiers...");
        ArrayList<String> schemaIds = new ArrayList<String>();
        for (StagingSchemaInfo schema : (List)staging.schemas(algorithm, version).execute().body()) {
            String id = schema.getId();
            if (!_ID_CHARACTERS.matcher(id).matches()) {
                _LOG.info(" **** skipping bad schema identifier: '{}' ****", (Object)id);
                continue;
            }
            schemaIds.add(id);
        }
        _LOG.info("{} valid schema idenfiers found.", (Object)schemaIds.size());
        String schemaDir = baseDirectory + "/" + algorithm + "/" + version + "/schemas";
        _LOG.info("Deleting all files from {}...", (Object)schemaDir);
        int count = UpdaterUtils.purgeDirectory(new File(schemaDir));
        _LOG.info("Removed {} files", (Object)count);
        String tableDir = baseDirectory + "/" + algorithm + "/" + version + "/tables";
        _LOG.info("Deleting all files from {}...", (Object)tableDir);
        count = UpdaterUtils.purgeDirectory(new File(tableDir));
        _LOG.info("Removed {} files", (Object)count);
        HashMap glossaryEntries = new HashMap();
        for (String tableId : tableIds) {
            StagingTable table = (StagingTable)staging.tableById(algorithm, version, tableId).execute().body();
            String tableText = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)table);
            Files.write(Paths.get(tableDir + "/" + table.getId() + ".json", new String[0]), tableText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            _LOG.info("Saved table: {}", (Object)table.getId());
            matches = (Set)staging.tableGlossary(algorithm, version, tableId, categories, Boolean.valueOf(true)).execute().body();
            matches.forEach(match -> glossaryEntries.put(match.getKeyword(), match.getId()));
        }
        tableIds.sort(String::compareTo);
        Files.write(Paths.get(tableDir + "/ids.txt", new String[0]), tableIds, StandardCharsets.UTF_8, new OpenOption[0]);
        _LOG.info("Saved table IDs to {}/ids.txt", (Object)tableDir);
        for (String schemaId : schemaIds) {
            StagingSchema schema = (StagingSchema)staging.schemaById(algorithm, version, schemaId).execute().body();
            String schemaText = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)schema);
            Files.write(Paths.get(schemaDir + "/" + schema.getId() + ".json", new String[0]), schemaText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            _LOG.info("Saved schema: {}", (Object)schema.getId());
            matches = (Set)staging.schemaGlossary(algorithm, version, schemaId, categories, Boolean.valueOf(true)).execute().body();
            matches.forEach(match -> glossaryEntries.put(match.getKeyword(), match.getId()));
        }
        schemaIds.sort(String::compareTo);
        Files.write(Paths.get(schemaDir + "/ids.txt", new String[0]), schemaIds, StandardCharsets.UTF_8, new OpenOption[0]);
        _LOG.info("Saved schema IDs to {}/ids.txt", (Object)schemaDir);
        String glossaryDir = baseDirectory + "/" + algorithm + "/" + version + "/glossary";
        _LOG.info("Deleting all files from {}...", (Object)glossaryDir);
        count = UpdaterUtils.purgeDirectory(new File(glossaryDir));
        _LOG.info("removed {} files", (Object)count);
        GlossaryService glossary = new SeerApi.Builder().connect().glossary();
        for (String glossaryId : glossaryEntries.values()) {
            Glossary entry = (Glossary)glossary.getById("latest", glossaryId).execute().body();
            String glossaryText = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new GlossaryDefinition(entry.getName(), entry.getDefinition(), entry.getAlternateName(), entry.getLastModified()));
            Files.write(Paths.get(glossaryDir + "/" + entry.getId() + ".json", new String[0]), glossaryText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            _LOG.info("Saved glossary term: {}", (Object)entry.getName());
        }
        List keywords = glossaryEntries.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "~" + (String)e.getValue()).collect(Collectors.toList());
        Files.write(Paths.get(glossaryDir + "/terms.txt", new String[0]), keywords, StandardCharsets.UTF_8, new OpenOption[0]);
        _LOG.info("Saved glossary terms to {}/terms.txt", (Object)schemaDir);
        stopwatch.stop();
        _LOG.info("Completed in {}", (Object)stopwatch);
    }

    private static int purgeDirectory(File dir) {
        int count = 0;
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IllegalStateException("Unable to create directory: " + dir);
            }
        } else {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) continue;
                    if (!file.delete()) {
                        throw new IllegalStateException("Unable to delete " + file.getName());
                    }
                    ++count;
                }
            }
        }
        return count;
    }
}

