/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.cs;

import com.imsweb.staging.StagingFileDataProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class CsDataProvider
extends StagingFileDataProvider {
    private static final Map<CsVersion, CsDataProvider> _PROVIDERS = new ConcurrentHashMap<CsVersion, CsDataProvider>();

    private CsDataProvider(CsVersion version) {
        super("cs", version.getVersion());
    }

    public static synchronized CsDataProvider getInstance() {
        return CsDataProvider.getInstance(CsVersion.LATEST);
    }

    public static synchronized CsDataProvider getInstance(CsVersion version) {
        return _PROVIDERS.computeIfAbsent(version, k -> new CsDataProvider(version));
    }

    public static enum CsVersion {
        LATEST("02.05.50"),
        V020550("02.05.50");

        private final String _version;

        private CsVersion(String version) {
            this._version = version;
        }

        public String getVersion() {
            return this._version;
        }
    }
}

