/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.entities.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.imsweb.staging.entities.Mapping;
import com.imsweb.staging.entities.impl.StagingKeyValue;
import com.imsweb.staging.entities.impl.StagingTablePath;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonPropertyOrder(value={"id", "name", "inclusion_tables", "exclusion_tables", "initial_context", "tables"})
public class StagingMapping
implements Mapping {
    private String _id;
    private String _name;
    private List<StagingTablePath> _inclusionTables;
    private List<StagingTablePath> _exclusionTables;
    private Set<StagingKeyValue> _initialContext;
    private List<StagingTablePath> _tablePaths;

    public StagingMapping() {
    }

    public StagingMapping(String id) {
        this.setId(id);
    }

    public StagingMapping(String id, String name) {
        this.setId(id);
        this.setName(name);
    }

    public StagingMapping(String id, List<StagingTablePath> tablePaths) {
        this._id = id;
        this._tablePaths = tablePaths;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @JsonProperty(value="inclusion_tables")
    public List<StagingTablePath> getInclusionTables() {
        return this._inclusionTables;
    }

    public void setInclusionTables(List<StagingTablePath> inclusionTables) {
        this._inclusionTables = inclusionTables;
    }

    @JsonProperty(value="exclusion_tables")
    public List<StagingTablePath> getExclusionTables() {
        return this._exclusionTables;
    }

    public void setExclusionTables(List<StagingTablePath> exclusionTables) {
        this._exclusionTables = exclusionTables;
    }

    @JsonProperty(value="initial_context")
    public Set<StagingKeyValue> getInitialContext() {
        return this._initialContext;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setInitialContext(Set<StagingKeyValue> initialContext) {
        this._initialContext = initialContext;
    }

    @JsonProperty(value="tables")
    public List<StagingTablePath> getTablePaths() {
        return this._tablePaths;
    }

    public void setTablePaths(List<StagingTablePath> tablePaths) {
        this._tablePaths = tablePaths;
    }

    public void addTablePath(StagingTablePath path) {
        if (this._tablePaths == null) {
            this._tablePaths = new ArrayList<StagingTablePath>();
        }
        this._tablePaths.add(path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StagingMapping mapping = (StagingMapping)o;
        return Objects.equals(this._id, mapping._id) && Objects.equals(this._name, mapping._name) && Objects.equals(this._inclusionTables, mapping._inclusionTables) && Objects.equals(this._exclusionTables, mapping._exclusionTables) && Objects.equals(this._initialContext, mapping._initialContext) && Objects.equals(this._tablePaths, mapping._tablePaths);
    }

    public int hashCode() {
        return Objects.hash(this._id, this._name, this._inclusionTables, this._exclusionTables, this._initialContext, this._tablePaths);
    }
}

