/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.eod;

import com.imsweb.staging.StagingFileDataProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class EodDataProvider
extends StagingFileDataProvider {
    private static final Map<EodVersion, EodDataProvider> _PROVIDERS = new ConcurrentHashMap<EodVersion, EodDataProvider>();

    private EodDataProvider(EodVersion version) {
        super("eod_public", version.getVersion());
    }

    public static synchronized EodDataProvider getInstance() {
        return EodDataProvider.getInstance(EodVersion.LATEST);
    }

    public static synchronized EodDataProvider getInstance(EodVersion version) {
        return _PROVIDERS.computeIfAbsent(version, k -> new EodDataProvider(version));
    }

    public static enum EodVersion {
        LATEST("2.1"),
        V2_1("2.1");

        private final String _version;

        private EodVersion(String version) {
            this._version = version;
        }

        public String getVersion() {
            return this._version;
        }
    }
}

