/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.tnm;

import com.imsweb.staging.StagingFileDataProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TnmDataProvider
extends StagingFileDataProvider {
    private static final Map<TnmVersion, TnmDataProvider> _PROVIDERS = new ConcurrentHashMap<TnmVersion, TnmDataProvider>();

    private TnmDataProvider(TnmVersion version) {
        super("tnm", version.getVersion());
    }

    public static synchronized TnmDataProvider getInstance() {
        return TnmDataProvider.getInstance(TnmVersion.LATEST);
    }

    public static synchronized TnmDataProvider getInstance(TnmVersion version) {
        return _PROVIDERS.computeIfAbsent(version, k -> new TnmDataProvider(version));
    }

    public static enum TnmVersion {
        LATEST("1.9"),
        V1_9("1.9");

        private final String _version;

        private TnmVersion(String version) {
            this._version = version;
        }

        public String getVersion() {
            return this._version;
        }
    }
}

