/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.toronto;

import com.imsweb.staging.StagingFileDataProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TorontoDataProvider
extends StagingFileDataProvider {
    private static final Map<TorontoVersion, TorontoDataProvider> _PROVIDERS = new ConcurrentHashMap<TorontoVersion, TorontoDataProvider>();

    private TorontoDataProvider(TorontoVersion version) {
        super("toronto", version.getVersion());
    }

    public static synchronized TorontoDataProvider getInstance() {
        return TorontoDataProvider.getInstance(TorontoVersion.LATEST);
    }

    public static synchronized TorontoDataProvider getInstance(TorontoVersion version) {
        return _PROVIDERS.computeIfAbsent(version, k -> new TorontoDataProvider(version));
    }

    public static enum TorontoVersion {
        LATEST("0.1"),
        V0_1("0.1");

        private final String _version;

        private TorontoVersion(String version) {
            this._version = version;
        }

        public String getVersion() {
            return this._version;
        }
    }
}

