/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.toronto;

import com.imsweb.staging.entities.StagingData;

public class TorontoStagingData
extends StagingData {
    public TorontoStagingData() {
    }

    public TorontoStagingData(String site, String hist) {
        super(site, hist);
    }

    public TorontoStagingData(String site, String hist, String ageAtDx) {
        super(site, hist);
        this.setInput(TorontoInput.AGE_DX, ageAtDx);
    }

    public String getInput(TorontoInput key) {
        return this.getInput(key.toString());
    }

    public void setInput(TorontoInput key, String value) {
        this.setInput(key.toString(), value);
    }

    public String getOutput(TorontoOutput key) {
        return this.getOutput(key.toString());
    }

    public static enum TorontoInput {
        PRIMARY_SITE("site"),
        HISTOLOGY("hist"),
        BEHAVIOR("behavior"),
        AGE_DX("age_dx"),
        YEAR_DX("year_dx"),
        EOD_PRIMARY_TUMOR("eod_primary_tumor"),
        EOD_REGIONAL_NODES("eod_regional_nodes"),
        EOD_METS("eod_mets"),
        NODES_POS("nodes_pos"),
        GRADE_PATH("grade_path"),
        GRADE_CLIN("grade_clin"),
        GRADE_POST_THERAPY_CLIN("grade_post_therapy_clin"),
        GRADE_POST_THERAPY_PATH("grade_post_therapy_path"),
        SCHEMA_ID("schema_id"),
        SHIMADA_CLASSIFICATION("shimada_classification"),
        S_CATEGORY_CLIN("s_category_clin"),
        DNA_PLOIDY("dna_ploidy"),
        N_MYC_APMLIFICATION("n_myc_amplification"),
        S_CATEGORY_PATH("s_category_path"),
        SIZE_SUMMARY("size_summary"),
        INGRSS("ingrss"),
        B_SYMPTOMS("b_symptoms"),
        MONTH_DX("month_dx"),
        MONTH_BIRTH("month_birth"),
        CHROM_11Q_STATUS("chrom_11q_status");

        private final String _name;

        private TorontoInput(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }

    public static enum TorontoOutput {
        TORONTO_ID("toronto_id"),
        TORONTO_VERSION_NUMBER("toronto_version_number"),
        TORONTO_T("toronto_t"),
        TORONTO_N("toronto_n"),
        TORONTO_M("toronto_m"),
        TORONTO_GROUP("toronto_group"),
        TORONTO_GRADE("toronto_grade"),
        DERIVED_VERSION("derived_version"),
        DERIVED_RISK_LEVEL("derived_risk_level"),
        DERIVED_ANN_ARBOR_STAGE("derived_ann_arbor_stage");

        private final String _name;

        private TorontoOutput(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }

    public static class TorontoStagingInputBuilder {
        private final TorontoStagingData _data = new TorontoStagingData();

        public TorontoStagingInputBuilder withInput(TorontoInput key, String value) {
            this._data.setInput(key, value);
            return this;
        }

        public TorontoStagingData build() {
            return this._data;
        }
    }
}

