/*
 * Decompiled with CFR 0.152.
 */
package com.indix.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.indix.client.IndixApiClient;
import com.indix.client.ProductsViewType;
import com.indix.client.impl.IndixApiConstants;
import com.indix.client.impl.IndixApiResponse;
import com.indix.exception.IndixApiException;
import com.indix.exception.InternalServerException;
import com.indix.httpClient.HttpClient;
import com.indix.httpClient.impl.HttpClientFactory;
import com.indix.models.jobs.JobInfo;
import com.indix.models.metadataResult.BrandsResult;
import com.indix.models.metadataResult.CategoriesResult;
import com.indix.models.metadataResult.StoresResult;
import com.indix.models.productDetailsResult.CatalogPremiumProductDetailsResult;
import com.indix.models.productDetailsResult.CatalogStandardProductDetailsResult;
import com.indix.models.productDetailsResult.OffersProductDetailsResult;
import com.indix.models.productDetailsResult.SummaryProductDetailsResult;
import com.indix.models.productDetailsResult.UniversalProductDetailsResult;
import com.indix.models.searchResult.CatalogPremiumSearchResult;
import com.indix.models.searchResult.CatalogStandardSearchResult;
import com.indix.models.searchResult.OffersSearchResult;
import com.indix.models.searchResult.SummarySearchResult;
import com.indix.models.searchResult.UniversalSearchResult;
import com.indix.models.suggestions.SuggestionsResult;
import com.indix.query.BulkLookupQuery;
import com.indix.query.BulkProductsQuery;
import com.indix.query.JobQuery;
import com.indix.query.ProductDetailsQuery;
import com.indix.query.Query;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndixApiClientImpl
implements IndixApiClient {
    private static final String APP_ID = "app_id";
    private static final String APP_KEY = "app_key";
    HttpClient httpClient;
    ObjectMapper jsonMapper;
    String scheme;
    String host;
    String appId;
    String appKey;
    static final Logger logger = LoggerFactory.getLogger(IndixApiClientImpl.class);

    private IndixApiClientImpl(String appId, String appKey, HttpClient httpClient, ObjectMapper jsonMapper, String scheme, String host) {
        this.appId = appId;
        this.appKey = appKey;
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.scheme = scheme;
        this.host = host;
    }

    public IndixApiClientImpl(String appId, String appKey) {
        this(appId, appKey, HttpClientFactory.newHttpClient(), IndixApiClientImpl.getNewObjectMapper(), "https", "api.indix.com");
    }

    public IndixApiClientImpl(String appId, String appKey, String scheme, String host) {
        this(appId, appKey, HttpClientFactory.newHttpClient(), IndixApiClientImpl.getNewObjectMapper(), scheme, host);
    }

    public IndixApiClientImpl(String appId, String appKey, HttpClient httpClient) {
        this(appId, appKey, httpClient, IndixApiClientImpl.getNewObjectMapper(), "https", "api.indix.com");
    }

    private static ObjectMapper getNewObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    private URI buildURI(String resource, Query searchQuery) throws URISyntaxException {
        return new URIBuilder().setScheme(this.scheme).setHost(this.host).setPath(resource).setParameters(searchQuery.getParameters()).addParameter(APP_ID, this.appId).addParameter(APP_KEY, this.appKey).build();
    }

    private String executeGET(String resource, Query searchQuery) throws URISyntaxException, IOException, IndixApiException {
        URI uri = this.buildURI(resource, searchQuery);
        logger.debug(uri.toString());
        return this.httpClient.GET(uri);
    }

    private InputStream executeGETStream(String resource, Query searchQuery) throws URISyntaxException, IOException, IndixApiException {
        URI uri = this.buildURI(resource, searchQuery);
        logger.debug(uri.toString());
        return this.httpClient.GETStream(uri);
    }

    private String executePOST(String resource, Query searchQuery) throws URISyntaxException, IOException, IndixApiException {
        URI uri = this.buildURI(resource, searchQuery);
        logger.debug(uri.toString());
        return this.httpClient.POST(uri, searchQuery.getParameters());
    }

    private String executePOST(String resource, Query searchQuery, File file) throws URISyntaxException, IOException, IndixApiException {
        URI uri = this.buildURI(resource, searchQuery);
        logger.debug(uri.toString());
        List<NameValuePair> params = searchQuery.getParameters();
        params.add((NameValuePair)new BasicNameValuePair(APP_ID, this.appId));
        params.add((NameValuePair)new BasicNameValuePair(APP_KEY, this.appKey));
        return this.httpClient.POST(uri, params, file);
    }

    static String buildPath(String ... pathFragments) {
        StringBuilder sb = new StringBuilder();
        for (String fragment : pathFragments) {
            sb.append("/");
            sb.append(fragment);
        }
        return sb.toString();
    }

    private String buildSearchResourcePath(ProductsViewType resourceView) {
        return IndixApiClientImpl.buildPath("v2", String.valueOf((Object)resourceView), "products");
    }

    private String buildProductDetailsPath(ProductsViewType resourceView, String mpid) {
        return IndixApiClientImpl.buildPath(this.buildSearchResourcePath(resourceView), mpid);
    }

    private String buildBulkSearchResourcePath(ProductsViewType resourceView) {
        return IndixApiClientImpl.buildPath("v2", String.valueOf((Object)resourceView), "bulk", "products");
    }

    private String buildBulkLookupResourcePath(ProductsViewType resourceView) {
        return IndixApiClientImpl.buildPath("v2", String.valueOf((Object)resourceView), "bulk", "lookup");
    }

    private String buildBulkJobStatusPath(String resource, String jobId) {
        return IndixApiClientImpl.buildPath(resource, jobId);
    }

    private static String buildBulkJobDownloadPath(String resource, String jobId) {
        return IndixApiClientImpl.buildPath(resource, jobId, "download");
    }

    @Override
    public OffersSearchResult getProductsOffersStandard(Query query) throws IndixApiException, IOException, URISyntaxException {
        String resource = this.buildSearchResourcePath(ProductsViewType.OFFERS_STANDARD);
        try {
            String content = this.executeGET(resource, query);
            IndixApiResponse searchIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<OffersSearchResult>>(){});
            return (OffersSearchResult)searchIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getProductsOffersStandard failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getProductsOffersStandard failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public SummarySearchResult getProductsSummary(Query query) throws IndixApiException, IOException, URISyntaxException {
        String resource = this.buildSearchResourcePath(ProductsViewType.SUMMARY);
        try {
            String content = this.executeGET(resource, query);
            IndixApiResponse searchIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<SummarySearchResult>>(){});
            return (SummarySearchResult)searchIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getProductsSummary failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getProductsSummary failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public OffersSearchResult getProductsOffersPremium(Query query) throws IndixApiException, IOException, URISyntaxException {
        String resource = this.buildSearchResourcePath(ProductsViewType.OFFERS_PREMIUM);
        try {
            String content = this.executeGET(resource, query);
            IndixApiResponse searchIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<OffersSearchResult>>(){});
            return (OffersSearchResult)searchIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getProductsOffersPremium failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getProductsOffersPremium failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public CatalogStandardSearchResult getProductsCatalogStandard(Query query) throws IndixApiException, IOException, URISyntaxException {
        String resource = this.buildSearchResourcePath(ProductsViewType.CATALOG_STANDARD);
        try {
            String content = this.executeGET(resource, query);
            IndixApiResponse searchIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<CatalogStandardSearchResult>>(){});
            return (CatalogStandardSearchResult)searchIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getProductsCatalogStandard failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getProductsCatalogStandard failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public CatalogPremiumSearchResult getProductsCatalogPremium(Query query) throws IndixApiException, IOException, URISyntaxException {
        String resource = this.buildSearchResourcePath(ProductsViewType.CATALOG_PREMIUM);
        try {
            String content = this.executeGET(resource, query);
            IndixApiResponse searchIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<CatalogPremiumSearchResult>>(){});
            return (CatalogPremiumSearchResult)searchIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getProductsCatalogPremium failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getProductsCatalogPremium failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public UniversalSearchResult getProductsUniversal(Query query) throws IndixApiException, IOException, URISyntaxException {
        String resource = this.buildSearchResourcePath(ProductsViewType.UNIVERSAL);
        try {
            String content = this.executeGET(resource, query);
            IndixApiResponse searchIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<UniversalSearchResult>>(){});
            return (UniversalSearchResult)searchIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getProductsUniversal failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getProductsUniversal failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public SummaryProductDetailsResult getProductDetailsSummary(ProductDetailsQuery query) throws IndixApiException, IOException, URISyntaxException {
        String resource = this.buildProductDetailsPath(ProductsViewType.SUMMARY, query.getMpid());
        try {
            String content = this.executeGET(resource, query);
            IndixApiResponse productDetailsIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<SummaryProductDetailsResult>>(){});
            return (SummaryProductDetailsResult)productDetailsIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getProductDetailsSummary failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getProductDetailsSummary failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public OffersProductDetailsResult getProductDetailsOffersStandard(ProductDetailsQuery query) throws IndixApiException, IOException, URISyntaxException {
        String resource = this.buildProductDetailsPath(ProductsViewType.OFFERS_STANDARD, query.getMpid());
        try {
            String content = this.executeGET(resource, query);
            IndixApiResponse productDetailsIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<OffersProductDetailsResult>>(){});
            return (OffersProductDetailsResult)productDetailsIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getProductDetailsOffersStandard failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getProductDetailsOffersStandard failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public OffersProductDetailsResult getProductDetailsOffersPremium(ProductDetailsQuery query) throws IndixApiException, IOException, URISyntaxException {
        String resource = this.buildProductDetailsPath(ProductsViewType.OFFERS_PREMIUM, query.getMpid());
        try {
            String content = this.executeGET(resource, query);
            IndixApiResponse productDetailsIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<OffersProductDetailsResult>>(){});
            return (OffersProductDetailsResult)productDetailsIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getProductDetailsOffersPremium failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getProductDetailsOffersPremium failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public CatalogStandardProductDetailsResult getProductDetailsCatalogStandard(ProductDetailsQuery query) throws IndixApiException, IOException, URISyntaxException {
        String resource = this.buildProductDetailsPath(ProductsViewType.CATALOG_STANDARD, query.getMpid());
        try {
            String content = this.executeGET(resource, query);
            IndixApiResponse productDetailsIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<CatalogStandardProductDetailsResult>>(){});
            return (CatalogStandardProductDetailsResult)productDetailsIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getProductDetailsCatalogStandard failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getProductDetailsCatalogStandard failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public CatalogPremiumProductDetailsResult getProductDetailsCatalogPremium(ProductDetailsQuery query) throws IndixApiException, IOException, URISyntaxException {
        String resource = this.buildProductDetailsPath(ProductsViewType.CATALOG_PREMIUM, query.getMpid());
        try {
            String content = this.executeGET(resource, query);
            IndixApiResponse productDetailsIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<CatalogPremiumProductDetailsResult>>(){});
            return (CatalogPremiumProductDetailsResult)productDetailsIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getProductDetailsCatalogPremium failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getProductDetailsCatalogPremium failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public UniversalProductDetailsResult getProductDetailsUniversal(ProductDetailsQuery query) throws IndixApiException, IOException, URISyntaxException {
        String resource = this.buildProductDetailsPath(ProductsViewType.UNIVERSAL, query.getMpid());
        try {
            String content = this.executeGET(resource, query);
            IndixApiResponse productDetailsIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<UniversalProductDetailsResult>>(){});
            return (UniversalProductDetailsResult)productDetailsIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getProductDetailsUniversal failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getProductDetailsUniversal failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public StoresResult getStores(Query query) throws IndixApiException, IOException, URISyntaxException {
        try {
            String content = this.executeGET(IndixApiConstants.STORES_RESOURCE, query);
            IndixApiResponse storesIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<StoresResult>>(){});
            return (StoresResult)storesIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getStores failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getStores failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public BrandsResult getBrands(Query query) throws IndixApiException, IOException, URISyntaxException {
        try {
            String content = this.executeGET(IndixApiConstants.BRANDS_RESOURCE, query);
            IndixApiResponse brandsIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<BrandsResult>>(){});
            return (BrandsResult)brandsIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getBrands failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getBrands failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public CategoriesResult getCategories(Query query) throws IndixApiException, IOException, URISyntaxException {
        try {
            String content = this.executeGET(IndixApiConstants.CATEGORIES_RESOURCE, query);
            IndixApiResponse categoriesIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<CategoriesResult>>(){});
            return (CategoriesResult)categoriesIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getCategories failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getCategories failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public SuggestionsResult getSuggestions(Query query) throws IndixApiException, IOException, URISyntaxException {
        try {
            String content = this.executeGET(IndixApiConstants.SUGGESTIONS_RESOURCE, query);
            IndixApiResponse suggestionsIndixApiResponse = (IndixApiResponse)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<IndixApiResponse<SuggestionsResult>>(){});
            return (SuggestionsResult)suggestionsIndixApiResponse.getResult();
        }
        catch (IndixApiException iae) {
            logger.error("getSuggestions failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getSuggestions failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public JobInfo postBulkJob(ProductsViewType productsViewType, BulkProductsQuery query) throws IndixApiException, IOException, URISyntaxException {
        String resource = this.buildBulkSearchResourcePath(productsViewType);
        try {
            String content = this.executePOST(resource, query);
            JobInfo job = (JobInfo)this.jsonMapper.readValue(content, JobInfo.class);
            return job;
        }
        catch (IndixApiException iae) {
            logger.error("postBulkJob failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("postBulkJob failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public JobInfo postBulkJob(ProductsViewType productsViewType, BulkLookupQuery query) throws IndixApiException, IOException, URISyntaxException {
        String resource = this.buildBulkLookupResourcePath(productsViewType);
        try {
            String content = this.executePOST(resource, query, query.getInputFile());
            JobInfo job = (JobInfo)this.jsonMapper.readValue(content, JobInfo.class);
            return job;
        }
        catch (IndixApiException iae) {
            logger.error("postBulkJob failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("postBulkJob failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public JobInfo getBulkJobStatus(JobQuery query) throws IndixApiException, IOException, URISyntaxException {
        String resource = this.buildBulkJobStatusPath(IndixApiConstants.BULK_JOB_RESOURCE, String.valueOf(query.getJobId()));
        try {
            String content = this.executeGET(resource, query);
            JobInfo jobStatus = (JobInfo)this.jsonMapper.readValue(content, JobInfo.class);
            return jobStatus;
        }
        catch (IndixApiException iae) {
            logger.error("getBulkJobStatus failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getBulkJobStatus failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public InputStream getBulkJobOutput(JobQuery query) throws IndixApiException, IOException, URISyntaxException {
        String resource = IndixApiClientImpl.buildBulkJobDownloadPath(IndixApiConstants.BULK_JOB_RESOURCE, String.valueOf(query.getJobId()));
        try {
            return this.executeGETStream(resource, query);
        }
        catch (IndixApiException iae) {
            logger.error("getBulkJobOutput failed: " + iae.getMessage());
            throw iae;
        }
        catch (JsonProcessingException e) {
            logger.error("getBulkJobOutput failed: " + e.getMessage());
            throw new InternalServerException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }
}

