/*
 * Decompiled with CFR 0.152.
 */
package com.indix.api.client;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.indix.api.exception.APIException;
import com.indix.api.query.Query;
import com.indix.api.util.JsonHelper;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class IndixClient {
    private final String baseUri = "https://api.indix.com/v1";
    private static final Client client = ((ClientBuilder)ClientBuilder.newBuilder().register(JacksonJsonProvider.class)).build();
    private String appId;
    private String appKey;

    public IndixClient(String appId, String appKey) {
        this.appId = appId;
        this.appKey = appKey;
    }

    public <T> T fetch(Query<T> query) throws APIException {
        Invocation.Builder request = this.fetchTarget(query).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        Response response = request.get();
        switch (response.getStatus()) {
            case 200: {
                String content = (String)response.readEntity(String.class);
                return JsonHelper.getObjectFromJson(content, query.getTypeReference());
            }
            case 400: {
                throw new APIException.BadRequest(this.getErrorMessage(response));
            }
            case 401: {
                throw new APIException.AuthenticationFailure(this.getErrorMessage(response));
            }
            case 402: {
                throw new APIException.UnauthorizedAccess(this.getErrorMessage(response));
            }
            case 429: {
                throw new APIException.LimitExceeded(this.getErrorMessage(response));
            }
        }
        throw new APIException(response.getStatusInfo().getReasonPhrase());
    }

    public <T> WebTarget fetchTarget(Query<T> query) {
        WebTarget target = client.target("https://api.indix.com/v1").queryParam("app_id", new Object[]{this.appId}).queryParam("app_key", new Object[]{this.appKey}).path(query.getResource());
        for (Map.Entry<String, String> entry : query.getParameters().entrySet()) {
            target = target.queryParam(entry.getKey(), new Object[]{entry.getValue()});
        }
        return target;
    }

    private String getErrorMessage(Response response) {
        Map entity = (Map)response.readEntity(Map.class);
        return (String)entity.get("message");
    }
}

