/*
 * Decompiled with CFR 0.152.
 */
package com.indix.api.query;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.indix.api.models.Product;
import com.indix.api.query.Query;

public class QueryProduct
extends Query<Product> {
    public QueryProduct(String productId) {
        super(new TypeReference<Product>(){}, String.format("/products/%s", productId));
    }

    public QueryProduct withPageNumber(int pageNumber) {
        Preconditions.checkArgument((pageNumber > 0 ? 1 : 0) != 0, (Object)"pageNumber cannot be negative");
        this.parameters.put("pageNumber", Integer.toString(pageNumber));
        return this;
    }

    public QueryProduct withView(Query.View viewName) {
        this.parameters.put("view", viewName.name().toLowerCase());
        return this;
    }
}

