/*
 * Decompiled with CFR 0.152.
 */
package com.indix.api.query;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.indix.api.models.ProductsResponse;
import com.indix.api.query.Query;
import java.util.List;

public class QueryProducts
extends Query<ProductsResponse> {
    public QueryProducts() {
        super(new TypeReference<ProductsResponse>(){}, String.format("/products", new Object[0]));
    }

    public QueryProducts withPriceHistoryAvailable(boolean isAvailable) {
        this.parameters.put("priceHistoryAvailable", Boolean.toString(isAvailable));
        return this;
    }

    public QueryProducts withPriceChange(Query.PriceChange priceChange) {
        this.parameters.put("priceChange", priceChange.name());
        return this;
    }

    public QueryProducts withOffersCount(int offersCount) {
        this.parameters.put("offersCount", Integer.toString(offersCount));
        return this;
    }

    public QueryProducts withSortedBy(Query.SortedBy sortBy) {
        this.parameters.put("sortBy", sortBy.name());
        return this;
    }

    public QueryProducts withStoreIds(List<Integer> storeIds) {
        Preconditions.checkNotNull(storeIds, (Object)"storeIds cannot be null");
        for (Integer storeId : storeIds) {
            Preconditions.checkArgument((storeId > 0 ? 1 : 0) != 0, (Object)"storeIds cannot be negative.");
        }
        this.parameters.put("storeId", joiner.join(storeIds));
        return this;
    }

    public QueryProducts withBrandIds(List<Integer> brandIds) {
        Preconditions.checkNotNull(brandIds, (Object)"brandIds cannot be null");
        for (Integer brandId : brandIds) {
            Preconditions.checkArgument((brandId > 0 ? 1 : 0) != 0, (Object)"brandIds cannot be negative.");
        }
        this.parameters.put("brandId", joiner.join(brandIds));
        return this;
    }

    public QueryProducts withCategoryId(int categoryId) {
        Preconditions.checkArgument((categoryId > 0 ? 1 : 0) != 0, (Object)"categoryId cannot be negative");
        this.parameters.put("categoryId", Integer.toString(categoryId));
        return this;
    }

    public QueryProducts withStartPrice(double startPrice) {
        Preconditions.checkArgument((startPrice > 0.0 ? 1 : 0) != 0, (Object)"product price cannot be negative");
        this.parameters.put("startPrice", Double.toString(startPrice));
        return this;
    }

    public QueryProducts withEndPrice(double endPrice) {
        Preconditions.checkArgument((endPrice > 0.0 ? 1 : 0) != 0, (Object)"product price cannot be negative");
        this.parameters.put("endPrice", Double.toString(endPrice));
        return this;
    }

    public QueryProducts withAvailability(Query.Availability availability) {
        this.parameters.put("availability", availability.name());
        return this;
    }

    public QueryProducts withQuery(String term) {
        this.parameters.put("query", term);
        return this;
    }

    public QueryProducts withURL(String url) {
        this.parameters.put("url", url);
        return this;
    }

    public QueryProducts withUPC(String upc) {
        this.parameters.put("upc", upc);
        return this;
    }

    public QueryProducts withMPN(String mpn) {
        this.parameters.put("mpn", mpn);
        return this;
    }

    public QueryProducts withSKU(String sku) {
        this.parameters.put("sku", sku);
        return this;
    }

    public QueryProducts withPageNumber(int pageNumber) {
        Preconditions.checkArgument((pageNumber > 0 ? 1 : 0) != 0, (Object)"page-number cannot be negative");
        this.parameters.put("pageNumber", Integer.toString(pageNumber));
        return this;
    }
}

