/*
 * Decompiled with CFR 0.152.
 */
package com.indix.api.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.indix.api.exception.APIException;
import java.io.IOException;

public class JsonHelper {
    private static final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public static <T> T getObjectFromJson(String content, TypeReference<T> typeReference) throws APIException {
        try {
            JsonNode root = mapper.readTree(content);
            JsonNode responseNode = root.get("response");
            return (T)mapper.convertValue((Object)responseNode, typeReference);
        }
        catch (IOException ex) {
            throw new APIException("Unable to parse json " + ex.getMessage());
        }
    }
}

