/*
 * Decompiled with CFR 0.152.
 */
package infobip.api.client;

import com.google.gson.GsonBuilder;
import infobip.api.config.Configuration;
import infobip.api.config.FormattedDate;
import infobip.api.config.TimeoutClientProvider;
import infobip.api.model.nc.logs.NumberContextLogsResponse;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;
import retrofit.http.Query;

public class GetNumberContextLogs {
    private final Configuration configuration;

    public GetNumberContextLogs(Configuration configuration) {
        this.configuration = configuration;
    }

    public NumberContextLogsResponse execute(String to, String[] bulkId, String[] messageId, String generalStatus, FormattedDate sentSince, FormattedDate sentUntil, Integer limit, String mcc, String mnc) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(this.configuration.getBaseUrl()).setRequestInterceptor(this.getRequestInterceptor()).setConverter((Converter)new GsonConverter(new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create())).setClient((Client.Provider)new TimeoutClientProvider(this.configuration)).build();
        GetNumberContextLogsService service = (GetNumberContextLogsService)restAdapter.create(GetNumberContextLogsService.class);
        return service.execute(to, bulkId, messageId, generalStatus, sentSince, sentUntil, limit, mcc, mnc);
    }

    private RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                if (GetNumberContextLogs.this.configuration != null && GetNumberContextLogs.this.configuration.getAuthorizationHeader() != null) {
                    request.addHeader("Authorization", GetNumberContextLogs.this.configuration.getAuthorizationHeader());
                    request.addHeader("User-Agent", "Java-Client-Library");
                }
            }
        };
    }

    static interface GetNumberContextLogsService {
        @GET(value="/number/1/logs")
        public NumberContextLogsResponse execute(@Query(value="to") String var1, @Query(value="bulkId") String[] var2, @Query(value="messageId") String[] var3, @Query(value="generalStatus") String var4, @Query(value="sentSince") FormattedDate var5, @Query(value="sentUntil") FormattedDate var6, @Query(value="limit") Integer var7, @Query(value="mcc") String var8, @Query(value="mnc") String var9);
    }
}

